# -*- coding: utf-8 -*-
from apis import trakt_api
from indexers.movies import Movies
from indexers.tvshows import TVShows
from modules import kodi_utils
from modules.utils import paginate_list
from modules.settings import paginate, page_limit, page_reference
logger = kodi_utils.logger

ls, sys, make_listitem, build_url, Thread, add_items = kodi_utils.local_string, kodi_utils.sys, kodi_utils.make_listitem, kodi_utils.build_url, kodi_utils.Thread, kodi_utils.add_items
set_content, set_sort_method, set_view_mode, end_directory = kodi_utils.set_content, kodi_utils.set_sort_method, kodi_utils.set_view_mode, kodi_utils.end_directory
add_dir, external_browse, dialog, sleep, json, get_icon = kodi_utils.add_dir, kodi_utils.external_browse, kodi_utils.dialog, kodi_utils.sleep, kodi_utils.json, kodi_utils.get_icon
trakt_icon, fanart, fen_clearlogo, add_item = get_icon('trakt'), kodi_utils.addon_fanart, kodi_utils.addon_clearlogo, kodi_utils.add_item
add2menu_str, add2folder_str, likelist_str, unlikelist_str = ls(32730), ls(32731), ls(32776), ls(32783)
newlist_str, deletelist_str, nextpage_str, jump2_str = ls(32780), ls(32781), ls(32799), ls(32964)

def search_trakt_lists(params):
	handle = int(sys.argv[1])
	def _builder():
		for item in lists:
			try:
				list_key = item['type']
				list_info = item[list_key]
				if list_key == 'officiallist': continue
				item_count = list_info['item_count']
				if list_info['privacy'] in ('private', 'friends') or item_count == 0: continue
				name, user, slug = list_info['name'], list_info['username'], list_info['ids']['slug']
				if not slug: continue
				cm = []
				cm_append = cm.append
				url = build_url({'mode': 'trakt.list.build_trakt_list', 'user': user, 'slug': slug})
				cm_append((add2menu_str,'RunPlugin(%s)' % build_url({'mode': 'menu_editor.add_external', 'name': name, 'iconImage': 'trakt'})))
				cm_append((add2folder_str,'RunPlugin(%s)' % build_url({'mode': 'menu_editor.shortcut_folder_add_item', 'name': name, 'iconImage': 'trakt'})))
				cm_append((likelist_str,'RunPlugin(%s)' % build_url({'mode': 'trakt.trakt_like_a_list', 'user': user, 'list_slug': slug})))
				cm_append((unlikelist_str,'RunPlugin(%s)' % build_url({'mode': 'trakt.trakt_unlike_a_list', 'user': user, 'list_slug': slug})))
				display = '[B]%s[/B] | [I]%s (x%s)[/I]' % (name.upper(), user, str(item_count))
				listitem = make_listitem()
				listitem.setLabel(display)
				listitem.setArt({'icon': trakt_icon, 'poster': trakt_icon, 'thumb': trakt_icon, 'fanart': fanart, 'banner': trakt_icon, 'clearlogo': fen_clearlogo})
				listitem.addContextMenuItems(cm)
				yield (url, listitem, True)
			except: pass
	try:
		mode = params.get('mode')
		page = params.get('new_page', '1')
		search_title = params.get('query')
		lists, pages = trakt_api.trakt_search_lists(search_title, page)
		add_items(handle, list(_builder()))
		if pages > page: add_dir({'mode': mode, 'search_title': search_title, 'new_page': str(int(page) + 1)}, nextpage_str, handle, iconImage='item_next')
	except: pass
	set_content(handle, 'files')
	end_directory(handle)
	if not external_browse(): set_view_mode('view.main')

def get_trakt_lists(params):
	handle = int(sys.argv[1])
	def _process():
		for item in lists:
			try:
				if list_type == 'liked_lists': item = item['list']
				cm = []
				cm_append = cm.append
				name, user, slug = item['name'], item['user']['ids']['slug'], item['ids']['slug']
				url = build_url({'mode': 'trakt.list.build_trakt_list', 'user': user, 'slug': slug, 'list_type': list_type})
				cm_append((add2menu_str,'RunPlugin(%s)' % build_url({'mode': 'menu_editor.add_external', 'name': name, 'iconImage': 'trakt'})))
				cm_append((add2folder_str,'RunPlugin(%s)' % build_url({'mode': 'menu_editor.shortcut_folder_add_item', 'name': name, 'iconImage': 'trakt'})))
				if list_type == 'liked_lists': cm_append((unlikelist_str,'RunPlugin(%s)' % build_url({'mode': 'trakt.trakt_unlike_a_list', 'user': user, 'list_slug': slug})))
				else:
					cm_append((newlist_str,'RunPlugin(%s)' % build_url({'mode': 'trakt.make_new_trakt_list'})))
					cm_append((deletelist_str,'RunPlugin(%s)' % build_url({'mode': 'trakt.delete_trakt_list', 'user': user, 'list_slug': slug})))
				listitem = make_listitem()
				listitem.setLabel(name)
				listitem.setArt({'icon': trakt_icon, 'poster': trakt_icon, 'thumb': trakt_icon, 'fanart': fanart, 'banner': trakt_icon, 'clearlogo': fen_clearlogo})
				listitem.addContextMenuItems(cm, replaceItems=False)
				yield (url, listitem, True)
			except: pass
	try:
		list_type = params['list_type']
		lists = trakt_api.trakt_get_lists(list_type)
		add_items(handle, list(_process()))
	except: pass
	set_content(handle, 'files')
	set_sort_method(handle, 'label')
	end_directory(handle)
	if not external_browse(): set_view_mode('view.main')

def get_trakt_trending_popular_lists(params):
	handle = int(sys.argv[1])
	def _process():
		for _list in lists:
			try:
				cm = []
				cm_append = cm.append
				item = _list['list']
				if item['user']['private'] or item.get('item_count', None) == 0: continue
				name, user, slug = item['name'], item['user']['ids']['slug'], item['ids']['slug']
				if not slug: continue
				if item['type'] == 'official': user = 'Trakt Official'
				if not user: continue
				url = build_url({'mode': 'trakt.list.build_trakt_list', 'user': user, 'slug': slug, 'list_type': 'user_lists'})
				listitem = make_listitem()
				listitem.setLabel(name)
				listitem.setArt({'icon': trakt_icon, 'poster': trakt_icon, 'thumb': trakt_icon, 'fanart': fanart, 'banner': trakt_icon, 'clearlogo': fen_clearlogo})
				cm_append((add2menu_str,'RunPlugin(%s)' % build_url({'mode': 'menu_editor.add_external', 'name': name, 'iconImage': 'trakt'})))
				cm_append((add2folder_str,'RunPlugin(%s)' % build_url({'mode': 'menu_editor.shortcut_folder_add_item', 'name': name, 'iconImage': 'trakt'})))
				if not user == 'Trakt Official':
					cm_append((likelist_str,'RunPlugin(%s)' % build_url({'mode': 'trakt.trakt_like_a_list', 'user': user, 'list_slug': slug})))
					cm_append((unlikelist_str,'RunPlugin(%s)' % build_url({'mode': 'trakt.trakt_unlike_a_list', 'user': user, 'list_slug': slug})))
				listitem.addContextMenuItems(cm)
				yield (url, listitem, True)
			except: pass
	try:
		list_type = params['list_type']
		lists = trakt_api.trakt_trending_popular_lists(list_type)
		add_items(handle, list(_process()))
	except: pass
	set_content(handle, 'files')
	end_directory(handle)
	if not external_browse(): set_view_mode('view.main')

def build_trakt_list(params):
	handle, is_widget, content, threads, item_list = int(sys.argv[1]), external_browse(), 'movies', [], []
	def _add_dir(url_params, list_name, iconImage='item_next', isFolder=True):
		icon = get_icon(iconImage)
		url = build_url(url_params)
		listitem = make_listitem()
		listitem.setLabel(list_name)
		listitem.setArt({'icon': icon, 'poster': icon, 'thumb': icon, 'fanart': fanart, 'banner': icon, 'clearlogo': fen_clearlogo})
		listitem.setInfo('video', {})
		add_item(handle, url, listitem, isFolder)
	def _process(function, _list, comparer):
		try:
			result = function({'list': [i['media_ids'] for i in _list], 'id_type': 'trakt_dict'}).worker()
			item_list.extend([(i, x['order']) for i in result for x in _list if [str(x['media_ids']['tmdb']) == i[1].getUniqueID('tmdb') and x['type'] == comparer][0]])
		except: pass
	try:
		user, slug, list_type, page_no = params.get('user'), params.get('slug'), params.get('list_type'), int(params.get('new_page', '1'))
		result = trakt_api.get_trakt_list_contents(list_type, user, slug)
		trakt_list = [{'media_ids': i[i['type']]['ids'], 'title': i[i['type']]['title'], 'type': i['type'], 'order': c} for c, i in enumerate(result)]
		if paginate(): process_list, all_pages, total_pages = paginate_list(trakt_list, page_no, page_limit())
		else: process_list, all_pages, total_pages = trakt_list, [], 1
		if total_pages > 2 and not is_widget:
				page_ref = page_reference()
				if page_ref != 3:
					_add_dir({'mode': 'build_navigate_to_page', 'media_type': 'Media', 'user': user, 'slug': slug, 'current_page': page_no, 'total_pages': total_pages,
							'transfer_mode': 'trakt.list.build_trakt_list', 'list_type': list_type, 'all_pages': all_pages, 'page_reference': page_ref},
							list_name=jump2_str, iconImage='item_jump', isFolder=False)
		movie_list = [i for i in process_list if i['type'] == 'movie']
		tvshow_list = [i for i in process_list if i['type'] == 'show']
		content = 'movies' if len(movie_list) > len(tvshow_list) else 'tvshows'
		for item in ((Movies, movie_list, 'movie'), (TVShows, tvshow_list, 'show')):
			if not item[1]: continue
			threaded_object = Thread(target=_process, args=item)
			threaded_object.start()
			threads.append(threaded_object)
		[i.join() for i in threads]
		item_list.sort(key=lambda k: k[1])
		add_items(handle, [i[0] for i in item_list])
		if total_pages > page_no: _add_dir({'mode': 'trakt.list.build_trakt_list', 'user': user, 'slug': slug, 'new_page': str(page_no + 1), 'list_type': list_type},
											list_name=nextpage_str)
	except: pass
	set_content(handle, content)
	end_directory(handle, False if is_widget else None)
	if params.get('refreshed') == 'true': sleep(1000)
	if not is_widget: set_view_mode('view.%s' % content, content)