# -*- coding: utf-8 -*-

import re
import sys
import random

from six.moves.urllib_parse import parse_qs, urlencode

from resources.lib.modules import client
from resources.lib.modules import control
from resources.lib.modules import log_utils


#####################################################################################################
#####################################################################################################


class jsonIPTV:
    def __init__(self):
        self.list = []
        self.categories = [
            {'title': 'All Channels', 'url': 'all_channels', 'image': None},
            {'title': 'Canada Channels', 'url': 'https://raw.githubusercontent.com/jewbmx/test/main/1/2/3/4/5/6/7/8/9/10/canada.json', 'image': None}
        ]


    def root(self):
        try:
            for i in self.categories:
                title = client.replaceHTMLCodes(i['title'])
                url = i['url']
                image = i['image']# if not i['image'] == (None or 'None') else 'DefaultVideo.png'
                self.list.append({'title': title, 'url': url, 'image': image, 'action': 'json_iptv_scrape_category'})
            addDirectory(self.list)
            return self.list
        except:
            log_utils.log('root', 1)
            return self.list


    def scrape_category(self, url):
        try:
            channels = client.scrapePage(url).json()
            for i in channels:
                title = client.replaceHTMLCodes(i['title'])
                link = i['url']
                image = i['image']# if not i['image'] == (None or 'None') else 'DefaultVideo.png'
                self.list.append({'title': title, 'url': link, 'image': image, 'action': 'json_iptv_play_channel'})
            addDirectory(self.list)
            return self.list
        except:
            log_utils.log('scrape_category', 1)
            return self.list


    def play_channel(self, url):
        try:
            item = control.item(path=url)
            item.setProperty('IsPlayable', 'true')
            return control.player.play(url, item)
        except:
            log_utils.log('play_channel', 1)
            control.infoDialog('Error : No Stream Available.', sound=False, icon='INFO')
            return


#####################################################################################################
#####################################################################################################


class ustvgo:
    def __init__(self):
        self.base_link = 'https://ustvgo.tv'
        self.list = []
        self.categories = [
            {'title': 'All Channels', 'url': 'all_channels', 'image': '/wp-content/uploads/2020/09/cropped-icon_small-192x192.jpg'},
            {'title': 'Random Channel', 'url': 'random_channel', 'image': '/wp-content/uploads/2020/09/cropped-icon_small-192x192.jpg'},
            {'title': 'Entertainment', 'url': '/category/entertainment/', 'image': '/wp-content/uploads/2020/09/cropped-icon_small-192x192.jpg'},
            {'title': 'Kids', 'url': '/category/kids/', 'image': '/wp-content/uploads/2020/09/cropped-icon_small-192x192.jpg'},
            {'title': 'News', 'url': '/category/news/', 'image': '/wp-content/uploads/2020/09/cropped-icon_small-192x192.jpg'},
            {'title': 'Sports', 'url': '/category/sports/', 'image': '/wp-content/uploads/2020/09/cropped-icon_small-192x192.jpg'}
        ]
        self.channels = [
            {'title': 'ABC', 'url': '/abc-live-streaming-free/', 'image': '/wp-content/uploads/2018/10/abc-269x151.jpg'},
            {'title': 'ABC 7 New York', 'url': '/abc-7-new-york/', 'image': '/wp-content/uploads/2020/09/cropped-icon_small-192x192.jpg'},
            {'title': 'ACC Network', 'url': '/acc-network/', 'image': '/wp-content/uploads/2021/06/accn.jpg'},
            {'title': 'AE', 'url': '/ae-networks-live-streaming-free/', 'image': '/wp-content/uploads/2019/01/AE.png'},
            {'title': 'AMC', 'url': '/amc-live/', 'image': '/wp-content/uploads/2019/01/AMC-1.png'},
            {'title': 'Animal Planet', 'url': '/animal-planet-live/', 'image': '/wp-content/uploads/2019/01/animal-planet.png'},
            {'title': 'BBCAmerica', 'url': '/bbc-america-live/', 'image': '/wp-content/uploads/2019/01/BBC.jpg'},
            {'title': 'BET', 'url': '/bet/', 'image': '/wp-content/uploads/2019/08/bet-269x151.png'},
            {'title': 'Big Ten Network', 'url': '/big-ten-network/', 'image': '/wp-content/uploads/2020/09/BTN.jpg'},
            {'title': 'Boomerang', 'url': '/boomerang/', 'image': '/wp-content/uploads/2019/08/Boomerang.png'},
            {'title': 'Bravo', 'url': '/bravo-channel-live-free/', 'image': '/wp-content/uploads/2019/01/bravo-269x151.png'},
            {'title': 'C-SPAN', 'url': '/c-span/', 'image': '/wp-content/uploads/2020/09/cspan-269x151-1.png'},
            {'title': 'Cartoon Network', 'url': '/cartoon-network/', 'image': '/wp-content/uploads/2019/01/cartoon-network.jpg'},
            {'title': 'CBS', 'url': '/cbs-live-streaming-free/', 'image': '/wp-content/uploads/2018/10/CBS-1.png'},
            {'title': 'CBS 2 New York', 'url': '/cbs-2-new-york/', 'image': '/wp-content/uploads/2020/09/cropped-icon_small-192x192.jpg'},
            {'title': 'CBS Sports Network', 'url': '/cbs-sports-network/', 'image': '/wp-content/uploads/2020/09/cbssn.jpg'},
            {'title': 'Cinemax', 'url': '/cinemax/', 'image': '/wp-content/uploads/2020/04/cinemax.jpg'},
            {'title': 'CMT', 'url': '/cmt/', 'image': '/wp-content/uploads/2019/08/cmt-1.png'},
            {'title': 'CNBC', 'url': '/cnbc-live-streaming-free/', 'image': '/wp-content/uploads/2018/10/cnbc-1.jpg'},
            {'title': 'CNN', 'url': '/cnn-live-streaming-free/', 'image': '/wp-content/uploads/2018/10/CNN-1.png'},
            {'title': 'Comedy Central', 'url': '/comedy-central-live-free/', 'image': '/wp-content/uploads/2019/01/comedy-central-269x151.png'},
            {'title': 'CW', 'url': '/the-cw-live-streaming-free/', 'image': '/wp-content/uploads/2019/01/cw-269x151.png'},
            {'title': 'CW 11 New York', 'url': '/the-cw-11-new-york/', 'image': '/wp-content/uploads/2020/09/cropped-icon_small-192x192.jpg'},
            {'title': 'Destination America', 'url': '/destination-america/', 'image': '/wp-content/uploads/2019/08/Destination_America.png'},
            {'title': 'Discovery', 'url': '/discovery-channel-live/', 'image': '/wp-content/uploads/2019/01/Discovery.png'},
            {'title': 'Disney', 'url': '/disney-channel-live-streaming-free/', 'image': '/wp-content/uploads/2019/01/disney-269x151.png'},
            {'title': 'DisneyJr', 'url': '/disneyjr/', 'image': '/wp-content/uploads/2019/08/disney-jr-768x432-1.png'},
            {'title': 'DisneyXD', 'url': '/disneyxd/', 'image': '/wp-content/uploads/2019/08/disney-xd-768x432-1.png'},
            {'title': 'Do it yourself (DIY)', 'url': '/diy/', 'image': '/wp-content/uploads/2019/08/diy.png'},
            {'title': 'E!', 'url': '/eonline/', 'image': '/wp-content/uploads/2019/08/E.png'},
            {'title': 'ESPN', 'url': '/espn-live/', 'image': '/wp-content/uploads/2019/01/espn-269x151.png'},
            {'title': 'ESPN2', 'url': '/espn2/', 'image': '/wp-content/uploads/2019/08/espn2-269x151.png'},
            {'title': 'ESPNews', 'url': '/espnews/', 'image': '/wp-content/uploads/2020/09/espnews-269x151-1.png'},
            {'title': 'ESPNU', 'url': '/espnu/', 'image': '/wp-content/uploads/2020/09/espnu-269x151-1.png'},
            {'title': 'FoodNetwork', 'url': '/food-network-live-free/', 'image': '/wp-content/uploads/2019/01/food-network-269x151.png'},
            {'title': 'FOX', 'url': '/fox-hd-live-streaming/', 'image': '/wp-content/uploads/2018/10/FOX-1.png'},
            {'title': 'FOX 5 New York', 'url': '/fox-5-new-york/', 'image': '/wp-content/uploads/2020/09/cropped-icon_small-192x192.jpg'},
            {'title': 'Fox Sports 1 (FS1)', 'url': '/fox-sports-1/', 'image': '/wp-content/uploads/2019/01/fs1-269x151.png'},
            {'title': 'Fox Sports 2 (FS2)', 'url': '/fox-sports-2/', 'image': '/wp-content/uploads/2019/01/fs2-269x151.png'},
            {'title': 'FoxBusiness', 'url': '/fox-business-live-streaming-free/', 'image': '/wp-content/uploads/2018/10/foxbusiness.jpg'},
            {'title': 'FoxNews', 'url': '/fox-news-live-streaming-free/', 'image': '/wp-content/uploads/2018/10/foxnews.jpg'},
            {'title': 'Freeform', 'url': '/freeform-channel-live-free/', 'image': '/wp-content/uploads/2019/01/freeform-269x151.png'},
            {'title': 'FX', 'url': '/fx-channel-live/', 'image': '/wp-content/uploads/2019/01/fx-269x151.png'},
            {'title': 'FX Movie Channel', 'url': '/fxm/', 'image': '/wp-content/uploads/2019/08/FXM.png'},
            {'title': 'FXX', 'url': '/fxx/', 'image': '/wp-content/uploads/2019/08/FXX.png'},
            {'title': 'Game Show Network', 'url': '/gsn/', 'image': '/wp-content/uploads/2019/08/GSN.jpg'},
            {'title': 'Golf Channel', 'url': '/golf-channel-live-free/', 'image': '/wp-content/uploads/2019/01/golf-269x151.png'},
            {'title': 'Hallmark Channel', 'url': '/hallmark-channel-live-streaming-free/', 'image': '/wp-content/uploads/2019/01/hallmark-chanel-logo.jpg'},
            {'title': 'Hallmark Movies and Mysteries', 'url': '/hallmark-movies-mysteries-live-streaming-free/', 'image': '/wp-content/uploads/2019/01/HMM_logo_black-700x245.jpg'},
            {'title': 'HBO', 'url': '/hbo/', 'image': '/wp-content/uploads/2019/01/hbo-269x151.png'},
            {'title': 'HGTV', 'url': '/hgtv-live-streaming-free/', 'image': '/wp-content/uploads/2019/01/HGTV-269x151.png'},
            {'title': 'History', 'url': '/history-channel-live/', 'image': '/wp-content/uploads/2019/01/History.png'},
            {'title': 'HLN', 'url': '/hln/', 'image': '/wp-content/uploads/2019/08/HLN.jpg'},
            {'title': 'Investigation Discovery', 'url': '/investigation-discovery-live-streaming-free/', 'image': '/wp-content/uploads/2019/01/id-269x151.jpg'},
            {'title': 'ION (WPXN) New York', 'url': '/ion-wpxn-new-york/', 'image': '/wp-content/uploads/2020/09/cropped-icon_small-192x192.jpg'},
            {'title': 'Lifetime', 'url': '/lifetime-channel-live/', 'image': '/wp-content/uploads/2019/01/Lifetime-269x151.png'},
            {'title': 'Lifetime Movie Network', 'url': '/lifetime-movies/', 'image': '/wp-content/uploads/2019/08/lifetimeM.jpeg'},
            {'title': 'MLB Network', 'url': '/mlb-network/', 'image': '/wp-content/uploads/2019/05/MLB.png'},
            {'title': 'Motor Trend', 'url': '/motortrend/', 'image': '/wp-content/uploads/2019/08/Motortrend-1.png'},
            {'title': 'MSNBC', 'url': '/msnbc-live-streaming-free/', 'image': '/wp-content/uploads/2018/10/msnbc_logo-269x151.jpg'},
            {'title': 'MTV', 'url': '/mtv/', 'image': '/wp-content/uploads/2019/08/mtv.jpg'},
            {'title': 'Nat Geo Wild', 'url': '/nat-geo-wild-live/', 'image': '/wp-content/uploads/2019/01/NatGeoWild.jpeg'},
            {'title': 'National Geographic', 'url': '/national-geographic-live/', 'image': '/wp-content/uploads/2019/01/National-Geographic-269x151.png'},
            {'title': 'NBA TV', 'url': '/nba-tv/', 'image': '/wp-content/uploads/2019/01/nbatv-269x151.jpg'},
            {'title': 'NBC', 'url': '/nbc/', 'image': '/wp-content/uploads/2018/10/nbc-logo.jpg'},
            {'title': 'NBC 4 New York', 'url': '/nbc-4-new-york/', 'image': '/wp-content/uploads/2020/09/cropped-icon_small-192x192.jpg'},
            {'title': 'NBC Sports (NBCSN)', 'url': '/nbc-sports/', 'image': '/wp-content/uploads/2019/01/nbcsn-269x151.jpg'},
            {'title': 'NFL Network', 'url': '/nfl-network-live-free/', 'image': '/wp-content/uploads/2019/01/nfln-logo-dark.png'},
            {'title': 'NFL RedZone', 'url': '/nfl-redzone/', 'image': '/wp-content/uploads/2020/09/NFLRZ.jpg'},
            {'title': 'Nickelodeon', 'url': '/nickelodeon-live-streaming-free/', 'image': '/wp-content/uploads/2019/01/Nickelodeon_2009.png'},
            {'title': 'Nicktoons', 'url': '/nicktoons/', 'image': '/wp-content/uploads/2019/08/nicktoons.png'},
            {'title': 'Olympic Channel', 'url': '/olympic-channel/', 'image': '/wp-content/uploads/2020/09/oly.jpg'},
            {'title': 'One America News Network', 'url': '/one-america-news-network/', 'image': '/wp-content/uploads/2019/09/OAN.jpg'},
            {'title': 'Oprah Winfrey Network (OWN)', 'url': '/own/', 'image': '/wp-content/uploads/2019/08/own.jpg'},
            {'title': 'Oxygen', 'url': '/oxygen/', 'image': '/wp-content/uploads/2019/08/Oxygen-1.png'},
            {'title': 'Paramount', 'url': '/paramount-network/', 'image': '/wp-content/uploads/2019/08/paramount.jpg'},
            {'title': 'PBS', 'url': '/pbs-live/', 'image': '/wp-content/uploads/2019/01/PBS.jpg'},
            {'title': 'POP', 'url': '/pop/', 'image': '/wp-content/uploads/2019/08/Pop_Network-1.png'},
            {'title': 'Science', 'url': '/science/', 'image': '/wp-content/uploads/2019/08/Science.jpg'},
            {'title': 'SEC Network', 'url': '/sec-network/', 'image': '/wp-content/uploads/2020/09/sec.jpg'},
            {'title': 'Showtime', 'url': '/showtime/', 'image': '/wp-content/uploads/2019/01/Showtime-269x151.png'},
            {'title': 'StarZ', 'url': '/starz-channel-live/', 'image': '/wp-content/uploads/2019/01/StarZ-269x151.png'},
            {'title': 'SundanceTV', 'url': '/sundance-tv/', 'image': '/wp-content/uploads/2019/08/sundance-tv.jpg'},
            {'title': 'SYFY', 'url': '/syfy-channel-live/', 'image': '/wp-content/uploads/2019/01/syfy-269x151.png'},
            {'title': 'TBS', 'url': '/tbs-channel-live-free/', 'image': '/wp-content/uploads/2019/01/tbs-269x151.png'},
            {'title': 'Telemundo', 'url': '/telemundo/', 'image': '/wp-content/uploads/2019/08/Telemundo.png'},
            {'title': 'Tennis Channel', 'url': '/tennis-channel-live-free/', 'image': '/wp-content/uploads/2019/01/TennisChannel.whiteBg.png'},
            {'title': 'The Weather Channel', 'url': '/the-weather-channel-live-streaming-free/', 'image': '/wp-content/uploads/2018/10/Weather-Channel-269x151.png'},
            {'title': 'TLC', 'url': '/tlc-live-free/', 'image': '/wp-content/uploads/2019/01/tlc-269x151.png'},
            {'title': 'TNT', 'url': '/tnt/', 'image': '/wp-content/uploads/2019/01/TNT.jpg'},
            {'title': 'Travel Channel', 'url': '/travel-channel-live-free/', 'image': '/wp-content/uploads/2019/01/Travel-269x151.png'},
            {'title': 'truTV', 'url': '/trutv/', 'image': '/wp-content/uploads/2019/08/TruTV-269x151.png'},
            {'title': 'Turner Classic Movies (TCM)', 'url': '/tcm/', 'image': '/wp-content/uploads/2019/05/TCM.png'},
            {'title': 'TV Land', 'url': '/tv-land-live-free/', 'image': '/wp-content/uploads/2019/01/TVLand-269x151.png'},
            {'title': 'Univision', 'url': '/univision/', 'image': '/wp-content/uploads/2019/08/univisionlogo.jpg'},
            {'title': 'USA Network', 'url': '/usa-network-live/', 'image': '/wp-content/uploads/2019/01/USA-Network-269x151.png'},
            {'title': 'VH1', 'url': '/vh1/', 'image': '/wp-content/uploads/2019/08/vh1.png'},
            {'title': 'We TV', 'url': '/we-tv/', 'image': '/wp-content/uploads/2019/08/wetv.jpg'},
            {'title': 'WWE Network', 'url': '/wwe-network/', 'image': '/wp-content/uploads/2019/09/wwe-269x151.png'},
            {'title': 'YES Network', 'url': '/yes-network/', 'image': '/wp-content/uploads/2020/04/yes.jpg'}
        ]


    def root(self):
        try:
            for i in self.categories:
                title = client.replaceHTMLCodes(i['title'])
                url = i['url']
                image = self.base_link + i['image']
                if i['url'] == 'random_channel':
                    action = 'ustvgo_scrape_channel'
                else:
                    action = 'ustvgo_scrape_category'
                self.list.append({'title': title, 'url': url, 'image': image, 'action': action})
            addDirectory(self.list)
            return self.list
        except:
            log_utils.log('root', 1)
            return self.list


    def scrape_category(self, url):
        try:
            if url == 'all_channels':
                for i in self.channels:
                    title = client.replaceHTMLCodes(i['title'])
                    link = self.base_link + i['url']
                    image = self.base_link + i['image']
                    self.list.append({'title': title, 'url': link, 'image': image, 'action': 'ustvgo_scrape_channel'})
            else:
                url = self.base_link + url
                html = client.scrapePage(url).text
                channels = client.parseDOM(html, 'div', attrs={'class': 'featured-image'})
                for i in channels:
                    title = client.parseDOM(i, 'a', ret='title')[0]
                    title = client.replaceHTMLCodes(title)
                    link = client.parseDOM(i, 'a', ret='href')[0]
                    image = client.parseDOM(i, 'img', ret='data-lazy-src')[0]
                    self.list.append({'title': title, 'url': link, 'image': image, 'action': 'ustvgo_scrape_channel'})
            addDirectory(self.list)
            return self.list
        except:
            log_utils.log('scrape_category', 1)
            return self.list


    def scrape_channel(self, url):
        try:
            if url == 'random_channel':
                choice = random.choice(self.channels)
                url = self.base_link + choice['url']
            if not url.startswith('http'):
                url = self.base_link + url
            html = client.scrapePage(url).text
            try:
                title = client.parseDOM(html, 'meta', attrs={'property': 'og:title'}, ret='content')[0]
            except:
                title = url.replace(self.base_link, '')
            title = client.replaceHTMLCodes(title)
            link = client.parseDOM(html, 'iframe', ret='src')[0]
            if not link.startswith('http'):
                link = self.base_link + link
            html = client.scrapePage(link).text
            link = re.findall("var hls_src='(.+?)';", html)[0]
            item = control.item(path=link)
            item.setInfo(type='Video', infoLabels={'title': title})
            item.setProperty('IsPlayable', 'true')
            return control.player.play(link, item)
        except:
            log_utils.log('scrape_channel', 1)
            control.infoDialog('Error : No Stream Available.', sound=False, icon='INFO')
            return


class ustv247:
    def __init__(self):
        self.base_link = 'https://ustv247.tv'
        self.list = []
        self.categories = [
            {'title': 'All Channels', 'url': 'all_channels', 'image': None},
            {'title': 'Random Channel', 'url': 'random_channel', 'image': None},
            {'title': 'Entertainment', 'url': '/entertainment/', 'image': None},
            {'title': 'Kids', 'url': '/kids/', 'image': None},
            {'title': 'Sports', 'url': '/sports/', 'image': None},
            {'title': 'U.S. News', 'url': '/usnews/', 'image': None}
        ]
        self.channels = [
            {'title': 'ABC', 'url': '/watch-abc-live-stream/', 'image': '/wp-content/uploads/2018/12/abc-269x151.jpg'},
            {'title': 'AE', 'url': '/ae-live-stream/', 'image': '/wp-content/uploads/2018/12/ae-269x151.png'},
            {'title': 'AMC', 'url': '/amc-live-stream/', 'image': '/wp-content/uploads/2018/12/AMC.png'},
            {'title': 'Animal Planet', 'url': '/animal-planet/', 'image': '/wp-content/uploads/2019/03/animal-planet.png'},
            {'title': 'BBC America', 'url': '/bbc-america/', 'image': '/wp-content/uploads/2019/03/BBC.jpg'},
            {'title': 'BET', 'url': '/bet/', 'image': '/wp-content/uploads/2021/01/bet.jpg'},
            {'title': 'Bravo', 'url': '/bravo/', 'image': '/wp-content/uploads/2019/03/bravo-269x151.png'},
            {'title': 'Cartoon Network', 'url': '/cartoon-network/', 'image': '/wp-content/uploads/2019/03/cartoon-network.jpg'},
            {'title': 'CBS', 'url': '/watch-cbs-live-stream/', 'image': '/wp-content/uploads/2018/12/CBS-1.png'},
            {'title': 'Cinemax', 'url': '/cinemax/', 'image': '/wp-content/uploads/2021/01/cinemax.jpg'},
            {'title': 'CMT', 'url': '/cmt/', 'image': '/wp-content/uploads/2021/01/cmt.jpg'},
            {'title': 'CNBC', 'url': '/cnbclive/', 'image': '/wp-content/uploads/2018/08/cnbc.jpg'},
            {'title': 'CNN', 'url': '/cnn-live-stream/', 'image': '/wp-content/uploads/2018/08/CNN-1.png'},
            {'title': 'Comedy Central', 'url': '/comedy-central/', 'image': '/wp-content/uploads/2019/03/comedy-central-269x151.png'},
            {'title': 'Discovery Channel', 'url': '/discovery-channel-live-stream/', 'image': '/wp-content/uploads/2018/12/Discovery.png'},
            {'title': 'Disney Channel', 'url': '/disney-channel/', 'image': '/wp-content/uploads/2019/03/disney-269x151.png'},
            {'title': 'Disney XD', 'url': '/disney-xd/', 'image': '/wp-content/uploads/2021/01/disney-xd.jpg'},
            {'title': 'Do it yourself', 'url': '/do-it-yourself/', 'image': '/wp-content/uploads/2021/01/diy.jpg'},
            {'title': 'E!', 'url': '/eonline/', 'image': '/wp-content/uploads/2021/01/E.jpg'},
            {'title': 'ESPN2', 'url': '/espn2/', 'image': '/wp-content/uploads/2021/01/espn2.jpg'},
            {'title': 'ESPN', 'url': '/espn/', 'image': '/wp-content/uploads/2018/12/ESPN.png'},
            {'title': 'ESPNU', 'url': '/espnu/', 'image': '/wp-content/uploads/2021/01/espnu.jpg'},
            {'title': 'Food Network', 'url': '/food-network/', 'image': '/wp-content/uploads/2019/03/food-network-269x151.png'},
            {'title': 'Fox Business', 'url': '/foxbusinesslive/', 'image': '/wp-content/uploads/2018/08/foxbusiness.jpg'},
            {'title': 'Fox News', 'url': '/foxnewslive/', 'image': '/wp-content/uploads/2018/08/foxnews.jpg'},
            {'title': 'Fox Sports 1', 'url': '/fox-sports-1/', 'image': '/wp-content/uploads/2020/08/fs1-269x151-1.png'},
            {'title': 'Fox Sports 2', 'url': '/fox-sports-2/', 'image': '/wp-content/uploads/2020/08/fs2-269x151-1.png'},
            {'title': 'FOX', 'url': '/watch-fox-channel-live-stream/', 'image': '/wp-content/uploads/2018/12/FOX-1.png'},
            {'title': 'Freeform', 'url': '/freeform/', 'image': '/wp-content/uploads/2019/03/freeform-269x151.png'},
            {'title': 'FX Movie Channel', 'url': '/fx-movie-channel/', 'image': '/wp-content/uploads/2021/01/FXM.jpg'},
            {'title': 'FX', 'url': '/fx-channel-live-stream/', 'image': '/wp-content/uploads/2018/12/fx-269x151.png'},
            {'title': 'FXX', 'url': '/fxx/', 'image': '/wp-content/uploads/2021/01/FXX.jpg'},
            {'title': 'Game Show Network', 'url': '/game-show-network/', 'image': '/wp-content/uploads/2021/01/GSN.jpg'},
            {'title': 'Golf Channel', 'url': '/golf-channel/', 'image': '/wp-content/uploads/2019/03/golf-269x151.png'},
            {'title': 'Hallmark Movies and Mysteries', 'url': '/hallmark-movies-mysteries/', 'image': '/wp-content/uploads/2019/03/HMM_logo_black-700x245.jpg'},
            {'title': 'Hallmark', 'url': '/hallmark-channel-live-stream/', 'image': '/wp-content/uploads/2018/12/hallmark-chanel-logo.jpg'},
            {'title': 'HBO', 'url': '/hbo/', 'image': '/wp-content/uploads/2019/03/hbo-269x151.png'},
            {'title': 'HGTV', 'url': '/hgtv-live-stream/', 'image': '/wp-content/uploads/2018/12/HGTV-269x151.png'},
            {'title': 'History', 'url': '/history-channel-live-stream/', 'image': '/wp-content/uploads/2018/12/History.png'},
            {'title': 'Investigation Discovery', 'url': '/investigation-discovery/', 'image': '/wp-content/uploads/2019/03/id-269x151.jpg'},
            {'title': 'Lifetime Movies', 'url': '/lifetime-movies/', 'image': '/wp-content/uploads/2021/01/lifetimeM.jpeg'},
            {'title': 'Lifetime', 'url': '/lifetime/', 'image': '/wp-content/uploads/2019/03/Lifetime-269x151.png'},
            {'title': 'MSNBC', 'url': '/msnbclive/', 'image': '/wp-content/uploads/2018/08/msnbc_logo-269x151.jpg'},
            {'title': 'MTV', 'url': '/mtv/', 'image': '/wp-content/uploads/2021/01/mtv.jpg'},
            {'title': 'National Geographic', 'url': '/national-geographic-live-stream/', 'image': '/wp-content/uploads/2018/12/NAtGeo.jpg'},
            {'title': 'NBC', 'url': '/watch-nbc-live-stream/', 'image': '/wp-content/uploads/2018/12/nbc-logo.jpg'},
            {'title': 'NBCSN', 'url': '/nbcsn/', 'image': '/wp-content/uploads/2021/01/nbcsn.jpg'},
            {'title': 'NFL Network', 'url': '/nfl-network/', 'image': '/wp-content/uploads/2019/03/nfln-logo-dark.png'},
            {'title': 'Nickelodeon', 'url': '/nickelodeon/', 'image': '/wp-content/uploads/2019/03/Nickelodeon_2009.png'},
            {'title': 'One America News Network', 'url': '/one-america-news-network/', 'image': '/wp-content/uploads/2019/03/OANN.jpg'},
            {'title': 'OWN', 'url': '/own/', 'image': '/wp-content/uploads/2021/01/own.jpg'},
            {'title': 'Oxygen', 'url': '/oxygen/', 'image': '/wp-content/uploads/2021/01/Oxygen.jpg'},
            {'title': 'Paramount Network', 'url': '/paramount-network/', 'image': '/wp-content/uploads/2021/01/spike.jpg'},
            {'title': 'PBS', 'url': '/pbs-live-stream/', 'image': '/wp-content/uploads/2018/12/PBS.jpg'},
            {'title': 'POP', 'url': '/pop/', 'image': '/wp-content/uploads/2021/01/pop.jpg'},
            {'title': 'Science', 'url': '/science/', 'image': '/wp-content/uploads/2021/01/Science.jpg'},
            {'title': 'Showtime', 'url': '/showtime/', 'image': '/wp-content/uploads/2019/03/Showtime-269x151.png'},
            {'title': 'Starz', 'url': '/starz/', 'image': '/wp-content/uploads/2019/03/StarZ-269x151.png'},
            {'title': 'Sundance TV', 'url': '/sundance-tv/', 'image': '/wp-content/uploads/2021/01/sundance-tv.jpg'},
            {'title': 'Syfy', 'url': '/syfy/', 'image': '/wp-content/uploads/2019/03/syfy-269x151.png'},
            {'title': 'TBS', 'url': '/tbs/', 'image': '/wp-content/uploads/2019/03/tbs-269x151.png'},
            {'title': 'Telemundo', 'url': '/telemundo/', 'image': '/wp-content/uploads/2021/01/Telemundo.jpg'},
            {'title': 'Tennis Channel', 'url': '/tennis-channel/', 'image': '/wp-content/uploads/2019/03/TennisChannel.whiteBg.png'},
            {'title': 'The CW', 'url': '/the-cw-live-stream/', 'image': '/wp-content/uploads/2018/12/cw-269x151.png'},
            {'title': 'The Weather Channel', 'url': '/watch-weather-channel-live-stream/', 'image': '/wp-content/uploads/2018/09/Weather-Channel-269x151.png'},
            {'title': 'TLC', 'url': '/tlc/', 'image': '/wp-content/uploads/2019/03/tlc-269x151.png'},
            {'title': 'TNT', 'url': '/tnt/', 'image': '/wp-content/uploads/2019/03/TNT.jpg'},
            {'title': 'Travel Channel', 'url': '/travel-channel/', 'image': '/wp-content/uploads/2019/03/Travel-269x151.png'},
            {'title': 'truTV', 'url': '/trutv/', 'image': '/wp-content/uploads/2021/01/TruTV.jpg'},
            {'title': 'Turner Classic Movies', 'url': '/turner-classic-movies/', 'image': '/wp-content/uploads/2019/03/TCM.png'},
            {'title': 'TV Land', 'url': '/tv-land/', 'image': '/wp-content/uploads/2019/03/TVLand-269x151.png'},
            {'title': 'Univision', 'url': '/univision/', 'image': '/wp-content/uploads/2021/01/univision.jpg'},
            {'title': 'USA Network', 'url': '/usa-network-live-stream/', 'image': '/wp-content/uploads/2018/12/USA-Network-269x151.png'},
            {'title': 'VH1', 'url': '/vh1/', 'image': '/wp-content/uploads/2021/01/vh1.jpg'},
            {'title': 'We TV', 'url': '/we-tv/', 'image': '/wp-content/uploads/2021/01/wetv.jpg'}
        ]


    def root(self):
        try:
            for i in self.categories:
                title = client.replaceHTMLCodes(i['title'])
                url = i['url']
                if i['image']:
                    image = self.base_link + i['image']
                else:
                    image = i['image']
                if i['url'] == 'random_channel':
                    action = 'ustv247_scrape_channel'
                else:
                    action = 'ustv247_scrape_category'
                self.list.append({'title': title, 'url': url, 'image': image, 'action': action})
            addDirectory(self.list)
            return self.list
        except:
            log_utils.log('root', 1)
            return self.list


    def scrape_category(self, url):
        try:
            if url == 'all_channels':
                for i in self.channels:
                    title = client.replaceHTMLCodes(i['title'])
                    link = self.base_link + i['url']
                    image = self.base_link + i['image']
                    self.list.append({'title': title, 'url': link, 'image': image, 'action': 'ustv247_scrape_channel'})
            else:
                url = self.base_link + url
                html = client.scrapePage(url).text
                channels = client.parseDOM(html, 'div', attrs={'class': 'featured-image'})
                for i in channels:
                    title = client.parseDOM(i, 'a', ret='title')[0]
                    title = client.replaceHTMLCodes(title)
                    link = client.parseDOM(i, 'a', ret='href')[0]
                    image = client.parseDOM(i, 'img', ret='data-lazy-src')[0]
                    self.list.append({'title': title, 'url': link, 'image': image, 'action': 'ustv247_scrape_channel'})
            addDirectory(self.list)
            return self.list
        except:
            log_utils.log('scrape_category', 1)
            return self.list


    def scrape_channel(self, url):
        try:
            if url == 'random_channel':
                choice = random.choice(self.channels)
                url = self.base_link + choice['url']
            if not url.startswith('http'):
                url = self.base_link + url
            html = client.scrapePage(url).text
            try:
                title = client.parseDOM(html, 'meta', attrs={'property': 'og:title'}, ret='content')[0]
            except:
                title = url.replace(self.base_link, '')
            title = client.replaceHTMLCodes(title)
            link = client.parseDOM(html, 'iframe', ret='src')[0]
            if not link.startswith('http'):
                link = self.base_link + link
            html = client.scrapePage(link).text
            link = re.findall("var hls_src='(.+?)';", html)[0]
            item = control.item(path=link)
            item.setInfo(type='Video', infoLabels={'title': title})
            item.setProperty('IsPlayable', 'true')
            return control.player.play(link, item)
        except:
            log_utils.log('scrape_channel', 1)
            control.infoDialog('Error : No Stream Available.', sound=False, icon='INFO')
            return


class watchnewslive:
    def __init__(self):
        self.base_link = 'https://watchnewslive.tv'
        self.list = []
        self.categories = [
            {'title': 'All Channels', 'url': 'all_channels', 'image': None},
            {'title': 'Random Channel', 'url': 'random_channel', 'image': None},
            {'title': 'Entertainment', 'url': '/entertainment/', 'image': None},
            {'title': 'Kids', 'url': '/kids/', 'image': None},
            {'title': 'Sports', 'url': '/sports/', 'image': None},
            {'title': 'News', 'url': '/news/', 'image': None}
        ]
        self.channels = [
            {'title': 'A&E', 'url': '/ae/', 'image': '/wp-content/uploads/2019/03/ae-269x151.png'},
            {'title': 'ABC', 'url': '/abc/', 'image': '/wp-content/uploads/2019/03/abc-269x151.jpg'},
            {'title': 'AMC', 'url': '/amc/', 'image': '/wp-content/uploads/2019/06/AMC.png'},
            {'title': 'Animal Planet', 'url': '/animal-planet/', 'image': '/wp-content/uploads/2019/03/animal-planet.png'},
            {'title': 'BBC America', 'url': '/bbc-america/', 'image': '/wp-content/uploads/2019/06/BBC.jpg'},
            {'title': 'Bravo', 'url': '/bravo/', 'image': '/wp-content/uploads/2019/06/bravo-269x151.png'},
            {'title': 'Cartoon Network', 'url': '/cartoon-network/', 'image': '/wp-content/uploads/2019/03/cartoon-network.jpg'},
            {'title': 'CBS', 'url': '/cbs/', 'image': '/wp-content/uploads/2019/03/CBS.png'},
            {'title': 'CNBC', 'url': '/watch-cnbc-live-stream-free-24-7/', 'image': '/wp-content/uploads/2018/05/cnbc.jpg'},
            {'title': 'CNN', 'url': '/cnn-live-streaming/', 'image': '/wp-content/uploads/2018/05/CNN-1.png'},
            {'title': 'Comedy Central', 'url': '/comedy-central/', 'image': '/wp-content/uploads/2019/06/comedy-central-269x151.png'},
            {'title': 'Discovery Channel', 'url': '/discovery-channel/', 'image': '/wp-content/uploads/2019/03/Discovery.png'},
            {'title': 'Disney Channel', 'url': '/disney-channel/', 'image': '/wp-content/uploads/2019/06/disney-269x151.png'},
            {'title': 'ESPN', 'url': '/espn/', 'image': '/wp-content/uploads/2019/06/ESPN.png'},
            {'title': 'Food Network', 'url': '/food-network/', 'image': '/wp-content/uploads/2019/06/food-network-269x151.png'},
            {'title': 'Fox', 'url': '/fox/', 'image': '/wp-content/uploads/2019/03/FOX-1.png'},
            {'title': 'Fox News', 'url': '/fox-news-live-stream-usa/', 'image': '/wp-content/uploads/2018/06/foxnews.jp'},
            {'title': 'Fox Business Network', 'url': '/watch-fox-business-network-fbn-free-24-7/', 'image': '/wp-content/uploads/2018/05/foxbusiness.jpg'},
            {'title': 'Freeform', 'url': '/freeform/', 'image': '/wp-content/uploads/2019/06/freeform-269x151.png'},
            {'title': 'FX', 'url': '/fx/', 'image': '/wp-content/uploads/2019/03/fx-269x151.png'},
            {'title': 'Golf', 'url': '/golf/', 'image': '/wp-content/uploads/2019/06/golf-269x151.png'},
            {'title': 'Hallmark Channel', 'url': '/hallmark-channel/', 'image': '/wp-content/uploads/2019/03/hallmark-chanel-logo.jpg'},
            {'title': 'Hallmark Movies & Mysteries', 'url': '/hallmark-movies-mysteries/', 'image': '/wp-content/uploads/2019/03/HMM_logo_black-700x245.jpg'},
            {'title': 'HBO', 'url': '/hbo/', 'image': '/wp-content/uploads/2019/06/hbo-269x151.png'},
            {'title': 'HGTV', 'url': '/hgtv/', 'image': '/wp-content/uploads/2019/03/HGTV-269x151.png'},
            {'title': 'History', 'url': '/history/', 'image': '/wp-content/uploads/2019/03/History.png'},
            {'title': 'Investigation Discovery', 'url': '/investigation-discovery/', 'image': '/wp-content/uploads/2019/03/id-269x151.jpg'},
            {'title': 'MSNBC', 'url': '/watch-msnbc-live-stream-24-7-free/', 'image': '/wp-content/uploads/2018/05/msnbc_logo-269x151.jpg'},
            {'title': 'Lifetime', 'url': '/lifetime/', 'image': '/wp-content/uploads/2019/06/Lifetime-269x151.png'},
            {'title': 'National Geographic', 'url': '/national-geographic/', 'image': '/wp-content/uploads/2019/03/NAtGeo.jpg'},
            {'title': 'NBC', 'url': '/nbc/', 'image': '/wp-content/uploads/2019/03/nbc-logo.jpg'},
            {'title': 'NFL Network', 'url': '/nfl-network/', 'image': '/wp-content/uploads/2019/06/nfln-logo-dark.png'},
            {'title': 'Nickelodeon', 'url': '/nickelodeon/', 'image': '/wp-content/uploads/2019/03/Nickelodeon_2009.png'},
            {'title': 'One America News Network', 'url': '/one-america-news-network-live/', 'image': '/wp-content/uploads/2019/03/OANN.jpg'},
            {'title': 'PBS', 'url': '/pbs/', 'image': '/wp-content/uploads/2019/03/PBS.jpg'},
            {'title': 'Showtime', 'url': '/showtime/', 'image': '/wp-content/uploads/2019/06/Showtime-269x151.png'},
            {'title': 'StarZ', 'url': '/starz/', 'image': '/wp-content/uploads/2019/06/StarZ-269x151.png'},
            {'title': 'SYFY', 'url': '/syfy/', 'image': '/wp-content/uploads/2019/03/syfy-269x151.png'},
            {'title': 'TBS', 'url': '/tbs/', 'image': '/wp-content/uploads/2019/06/tbs-269x151.png'},
            {'title': 'Tennis Channel', 'url': '/tennis-channel/', 'image': '/wp-content/uploads/2019/06/TennisChannel.whiteBg.png'},
            {'title': 'The CW', 'url': '/the-cw/', 'image': '/wp-content/uploads/2019/03/cw-269x151.png'},
            {'title': 'The Weather Channel', 'url': '/the-weather-channel-live-stream/', 'image': '/wp-content/uploads/2018/09/Weather-Channel-269x151.png'},
            {'title': 'TLC', 'url': '/tlc/', 'image': '/wp-content/uploads/2019/06/tlc-269x151.png'},
            {'title': 'TNT', 'url': '/tnt/', 'image': '/wp-content/uploads/2019/06/TNT.jpg'},
            {'title': 'Travel Channel', 'url': '/travel-channel/', 'image': '/wp-content/uploads/2019/06/Travel-269x151.png'},
            {'title': 'Turner Classic Movies', 'url': '/turner-classic-movies/', 'image': '/wp-content/uploads/2019/06/TCM.png'},
            {'title': 'TV Land', 'url': '/tv-land/', 'image': '/wp-content/uploads/2019/06/TVLand-269x151.png'},
            {'title': 'USA Network', 'url': '/usa-network/', 'image': '/wp-content/uploads/2019/03/USA-Network-269x151.png'}
        ]


    def root(self):
        try:
            for i in self.categories:
                title = client.replaceHTMLCodes(i['title'])
                url = i['url']
                if i['image']:
                    image = self.base_link + i['image']
                else:
                    image = i['image']
                if i['url'] == 'random_channel':
                    action = 'watchnewslive_scrape_channel'
                else:
                    action = 'watchnewslive_scrape_category'
                self.list.append({'title': title, 'url': url, 'image': image, 'action': action})
            addDirectory(self.list)
            return self.list
        except:
            log_utils.log('root', 1)
            return self.list


    def scrape_category(self, url):
        try:
            if url == 'all_channels':
                for i in self.channels:
                    title = client.replaceHTMLCodes(i['title'])
                    link = self.base_link + i['url']
                    image = self.base_link + i['image']
                    self.list.append({'title': title, 'url': link, 'image': image, 'action': 'watchnewslive_scrape_channel'})
            else:
                url = self.base_link + url
                html = client.scrapePage(url).text
                channels = client.parseDOM(html, 'div', attrs={'class': 'featured-image'})
                for i in channels:
                    title = client.parseDOM(i, 'a', ret='title')[0]
                    title = client.replaceHTMLCodes(title)
                    link = client.parseDOM(i, 'a', ret='href')[0]
                    image = client.parseDOM(i, 'img', ret='data-lazy-src')[0]
                    self.list.append({'title': title, 'url': link, 'image': image, 'action': 'watchnewslive_scrape_channel'})
            addDirectory(self.list)
            return self.list
        except:
            log_utils.log('scrape_category', 1)
            return self.list



    def scrape_channel(self, url):
        try:
            if url == 'random_channel':
                choice = random.choice(self.channels)
                url = self.base_link + choice['url']
            if not url.startswith('http'):
                url = self.base_link + url
            html = client.scrapePage(url).text
            try:
                title = client.parseDOM(html, 'meta', attrs={'property': 'og:title'}, ret='content')[0]
            except:
                title = url.replace(self.base_link, '')
            title = client.replaceHTMLCodes(title)
            link = client.parseDOM(html, 'iframe', ret='src')[0]
            if not link.startswith('http'):
                link = self.base_link + link
            html = client.scrapePage(link).text
            link = re.findall("var hls_src='(.+?)';", html)[0]
            item = control.item(path=link)
            item.setInfo(type='Video', infoLabels={'title': title})
            item.setProperty('IsPlayable', 'true')
            return control.player.play(link, item)
        except:
            log_utils.log('scrape_channel', 1)
            control.infoDialog('Error : No Stream Available.', sound=False, icon='INFO')
            return


def addDirectory(items, queue=False, isFolder=True):
    if items == None or len(items) == 0:
        control.idle()
    sysaddon = sys.argv[0]
    syshandle = int(sys.argv[1])
    addonFanart = control.addonFanart()
    for i in items:
        try:
            url = '%s?action=%s&url=%s' % (sysaddon, i['action'], i['url'])
            title = i['title']
            thumb = i['image'] if not i['image'] == (None or 'None') else 'DefaultVideo.png'
            item = control.item(label=title)
            item.setProperty('IsPlayable', 'true')
            item.setArt({'icon': thumb, 'thumb': thumb, 'fanart': addonFanart})
            control.addItem(handle=syshandle, url=url, listitem=item, isFolder=isFolder)
        except Exception:
            log_utils.log('addDirectory', 1)
            pass
    control.content(syshandle, 'addons')
    control.directory(syshandle, cacheToDisc=True)


