# -*- coding: utf-8 -*-

import re

from six.moves.urllib_parse import parse_qs, urlencode

from resources.lib.modules import client
from resources.lib.modules import cleantitle
from resources.lib.modules import log_utils
from resources.lib.modules import scrape_sources


class source:
    def __init__(self):
        try:
            self.results = []
            self.domains = ['watchserieshd.stream']
            self.base_link = 'https://watchserieshd.stream'
            self.search_link = '/?s=%s'
        except Exception:
            #log_utils.log('__init__', 1)
            return


    def movie(self, imdb, title, localtitle, aliases, year):
        try:
            url = {'imdb': imdb, 'title': title, 'year': year}
            url = urlencode(url)
            return url
        except:
            #log_utils.log('movie', 1)
            return


    def tvshow(self, imdb, tvdb, tvshowtitle, localtvshowtitle, aliases, year):
        try:
            url = {'imdb': imdb, 'tvdb': tvdb, 'tvshowtitle': tvshowtitle, 'year': year}
            url = urlencode(url)
            return url
        except:
            #log_utils.log('tvshow', 1)
            return


    def episode(self, url, imdb, tvdb, title, premiered, season, episode):
        try:
            if not url:
                return
            url = parse_qs(url)
            url = dict([(i, url[i][0]) if url[i] else (i, '') for i in url])
            url['title'], url['premiered'], url['season'], url['episode'] = title, premiered, season, episode
            url = urlencode(url)
            return url
        except:
            #log_utils.log('episode', 1)
            return


    def sources(self, url, hostDict):
        try:
            if url == None:
                return self.results
            data = parse_qs(url)
            data = dict([(i, data[i][0]) if data[i] else (i, '') for i in data])
            title = data['tvshowtitle'] if 'tvshowtitle' in data else data['title']
            year = data['year']
            search_title = cleantitle.get_plus(title)
            check_term = '%s (%s)' % (title, year)
            check_title = cleantitle.get_plus(check_term)
            search_url = self.base_link + self.search_link % search_title
            html = client.scrapePage(search_url).text
            results = re.findall('<a class="title" title="(.+?)" href="(.+?)">', html)
            results = [(i[0], i[1]) for i in results if len(i[0]) > 0 and len(i[1]) > 0]
            result_url = [i[1] for i in results if check_title == cleantitle.get_plus(i[0])][0]
            if 'tvshowtitle' in data:
                check_url = '-season-%s-episode-%s/' % (data['season'], data['episode'])
                show_html = client.scrapePage(result_url).text
                results = client.parseDOM(show_html, 'a', ret='href')
                result_url = [i for i in results if check_url in i][0]
            result_html = client.scrapePage(result_url).text
            if 'tvshowtitle' in data:
                links = client.parseDOM(result_html, 'li', ret='data-vs')
            else:
                links = client.parseDOM(result_html, 'div', ret='data-vs')
            headers = {'User-Agent': client.UserAgent, 'Referer': result_url}
            for link in links:
                link = client.request(link, headers=headers, output='geturl')
                for source in scrape_sources.process(hostDict, link):
                    self.results.append(source)
            return self.results
        except:
            #log_utils.log('sources', 1)
            return self.results


    def resolve(self, url):
        return url


