import zipfile

def auto(_in, _out):

    return allNoProgress(_in, _out)
	
def all(_in, _out, dp=None):
    if dp:
        return allWithProgress(_in, _out, dp)

    return allNoProgress(_in, _out)
        

def allNoProgress(_in, _out):
    try:
        zin = zipfile.ZipFile(_in, 'r')
        zin.extractall(_out)
    
    except Exception as e:
        print (e)
        return False

    return True


def allWithProgress(_in, _out, dp):
    zin    = zipfile.ZipFile(_in,  'r')
    nFiles = float(len(zin.infolist()))
    count  = 0

    try:
        for item in zin.infolist():
            count += 1
            update = count / nFiles * 100
            dp.update(int(update))
            try:
                zin.extract(item, _out)
            except Exception as e:
                print (e)

    
    except Exception as e:
        print (e)
        return False

    return True