# -*- coding: utf-8 -*-
#
# Copyright (C) 2015,2016,2017,2018,2019 RACC
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 5 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from __future__ import unicode_literals

import sys
import xbmc
import xbmcgui
import xbmcaddon
import xbmcplugin
from xbmcgui import ListItem
from routing import Plugin

import os
import traceback
import requests
import requests_cache
from datetime import timedelta
from base64 import b64encode, b64decode
from binascii import a2b_hex
from Cryptodome.Cipher import PKCS1_v1_5 as Cipher_PKCS1_v1_5
from Cryptodome.Cipher import DES
from Cryptodome.PublicKey import RSA
from Cryptodome.Util.Padding import unpad


try:
    from urllib.parse import quote_from_bytes as orig_quote
except ImportError:
    from urllib import quote as orig_quote

addon = xbmcaddon.Addon()
plugin = Plugin()
plugin.name = addon.getAddonInfo("name")
user_agent = "Dalvik/2.1.0 (Linux; U; Android 5.1.1; AFTS Build/LVY48F)"
player_user_agent = "mediaPlayerhttp/1.9 (Linux;Android 5.1) ExoPlayerLib/2.6.1"
USER_DATA_DIR = xbmc.translatePath(addon.getAddonInfo("profile")).decode("utf-8")  # !!
CACHE_TIME = int(addon.getSetting("cache_time"))
CACHE_FILE = os.path.join(USER_DATA_DIR, "cache")
expire_after = timedelta(hours=CACHE_TIME)

if not os.path.exists(USER_DATA_DIR):
    os.makedirs(USER_DATA_DIR)

token_url = "https://taptube.net/tv/index.php?case=get_channel_link_with_token_latest"
list_url = "https://taptube.net/tv/index.php?case=get_all_channels"

s = requests_cache.CachedSession(CACHE_FILE, allowable_methods="POST", expire_after=expire_after, old_data_on_error=True, ignored_parameters=["payload"])
s.headers.update({"User-Agent": "USER-AGENT-tvtap-APP-V2"})


def check_for_success(resp, *args, **kwargs):
    resp.raise_for_status()
    if not resp.json().get("success") == 1:
        resp.status_code = 404
        return resp


s.hooks["response"] = check_for_success


def quote(s, safe=""):
    return orig_quote(s.encode("utf-8"), safe.encode("utf-8"))


def payload():
    _pubkey = RSA.importKey(
        a2b_hex(
            "30819f300d06092a864886f70d010101050003818d003081890281"
            "8100bfa5514aa0550688ffde568fd95ac9130fcdd8825bdecc46f1"
            "8f6c6b440c3685cc52ca03111509e262dba482d80e977a938493ae"
            "aa716818efe41b84e71a0d84cc64ad902e46dbea2ec61071958826"
            "4093e20afc589685c08f2d2ae70310b92c04f9b4c27d79c8b5dbb9"
            "bd8f2003ab6a251d25f40df08b1c1588a4380a1ce8030203010001"
        )
    )
    _msg = a2b_hex(
        "7b224d4435223a22695757786f45684237686167747948392b58563052513d3d5c6e222c22534"
        "84131223a2242577761737941713841327678435c2f5450594a74434a4a544a66593d5c6e227d"
    )
    cipher = Cipher_PKCS1_v1_5.new(_pubkey)
    return b64encode(cipher.encrypt(_msg))


@plugin.route("/")
def root():
    list_items = []
    r = s.post(list_url, headers={"app-token": "37a6259cc0c1dae299a7866489dff0bd"}, data={"payload": payload(), "username": "603803577"}, timeout=5)
    ch = r.json()
    category_list = []
    if ch["success"] == 1:
        for c in ch["msg"]["channels"]:
            category = "{0}".format(c.get("cat_name"))
            if category not in category_list:
                category_list.append(category)
                li = ListItem(category)
                url = plugin.url_for(list_channels, cat_id=c.get("cat_id"))
                list_items.append((url, li, True))

        xbmcplugin.addSortMethod(plugin.handle, xbmcplugin.SORT_METHOD_LABEL)
        xbmcplugin.addDirectoryItems(plugin.handle, list_items)
        xbmcplugin.endOfDirectory(plugin.handle)
    else:
        dialog = xbmcgui.Dialog()
        dialog.notification(plugin.name, ch.get("msg"), xbmcgui.NOTIFICATION_ERROR)
        xbmcplugin.endOfDirectory(plugin.handle, False)


@plugin.route("/list_channels/<cat_id>")
def list_channels(cat_id=None):
    list_items = []
    r = s.post(list_url, headers={"app-token": "37a6259cc0c1dae299a7866489dff0bd"}, data={"payload": payload(), "username": "603803577"}, timeout=5)
    ch = r.json()
    if ch["success"] == 1:
        for c in ch["msg"]["channels"]:
            if c["cat_id"] == cat_id:
                image = "https://taptube.net/tv/{0}|User-Agent={1}".format(quote(c.get("img"), "/"), quote(user_agent))
                title = "{0} - {1}".format(c.get("country"), c.get("channel_name").rstrip(".,-"))
                li = ListItem(title)
                li.setProperty("IsPlayable", "true")
                li.setArt({"thumb": image, "icon": image})
                li.setInfo(type="Video", infoLabels={"Title": title, "mediatype": "video"})
                li.setContentLookup(False)
                url = plugin.url_for(play, ch_id=c["pk_id"])
                list_items.append((url, li, False))

        xbmcplugin.addSortMethod(plugin.handle, xbmcplugin.SORT_METHOD_LABEL)
        xbmcplugin.addDirectoryItems(plugin.handle, list_items)
        xbmcplugin.endOfDirectory(plugin.handle)
    else:
        dialog = xbmcgui.Dialog()
        dialog.notification(plugin.name, ch.get("msg"), xbmcgui.NOTIFICATION_ERROR)
        xbmcplugin.endOfDirectory(plugin.handle, False)


@plugin.route("/play/<ch_id>/play.pvr")
def play(ch_id):
    r = s.post(list_url, headers={"app-token": "37a6259cc0c1dae299a7866489dff0bd"}, data={"payload": payload(), "username": "603803577"}, timeout=5)
    ch = r.json()
    if ch["success"] == 1:
        for c in ch["msg"]["channels"]:
            if c["pk_id"] == ch_id:
                selected_channel = c
                break

        title = selected_channel.get("channel_name")
        image = "https://taptube.net/tv/{0}|User-Agent={1}".format(quote(c.get("img"), "/"), quote(user_agent))

        with s.cache_disabled():
            r = s.post(
                token_url,
                headers={"app-token": "37a6259cc0c1dae299a7866489dff0bd"},
                data={"payload": payload(), "channel_id": ch_id, "username": "603803577"},
                timeout=15,
            )
        token = r.json()
        links = []
        if token["success"] == 1:
            for stream in token["msg"]["channel"][0].keys():
                if "stream" in stream or "chrome_cast" in stream:
                    _crypt_link = token["msg"]["channel"][0][stream]
                    if _crypt_link:
                        d = DES.new(b"98221122", DES.MODE_ECB)
                        link = unpad(d.decrypt(b64decode(_crypt_link)), 8).decode("utf-8")
                        if not link == "dummytext" and link not in links:
                            links.append(link)

            if addon.getSetting("autoplay") == "true":
                link = links[0]
            elif len(links) > 1:
                dialog = xbmcgui.Dialog()
                ret = dialog.select("Choose Stream", links)
                link = links[ret]
            else:
                link = links[0]

            if link.startswith("http"):
                media_url = "{0}|User-Agent={1}".format(link, quote(player_user_agent))
            else:
                media_url = link

            if "playlist.m3u8" in media_url:
                if addon.getSetting("inputstream") == "true":
                    li = ListItem(title, path=media_url)
                    li.setMimeType("application/vnd.apple.mpegurl")
                    li.setProperty("inputstreamaddon", "inputstream.adaptive")
                    li.setProperty("inputstream.adaptive.manifest_type", "hls")
                    li.setProperty("inputstream.adaptive.stream_headers", media_url.split("|")[-1])
                else:
                    li = ListItem(title, path=media_url)
                    li.setMimeType("application/vnd.apple.mpegurl")
            else:
                li = ListItem(title, path=media_url)

            li.setArt({"thumb": image, "icon": image})
            li.setContentLookup(False)
            xbmcplugin.setResolvedUrl(plugin.handle, True, li)
        else:
            xbmcplugin.setResolvedUrl(plugin.handle, False, ListItem())
    else:
        xbmcplugin.setResolvedUrl(plugin.handle, False, ListItem())


if __name__ == "__main__":
    try:
        plugin.run(sys.argv)
        s.close()
    except requests.exceptions.RequestException as e:
        dialog = xbmcgui.Dialog()
        dialog.notification(plugin.name, str(e), xbmcgui.NOTIFICATION_ERROR)
        traceback.print_exc()
        xbmcplugin.endOfDirectory(plugin.handle, False)
    except (ImportError, UnicodeDecodeError):
        """ Invalidate cache when requests version changes """
        s.cache.clear()
