# -*- coding: utf-8 -*-

import sys
try:
	from urlparse import parse_qsl
except:
	from urllib.parse import parse_qsl

from shadowopenscrapers import sources_shadowopenscrapers
from shadowopenscrapers.modules import control

params = dict(parse_qsl(sys.argv[2].replace('?', '')))
action = params.get('action')
mode = params.get('mode')
query = params.get('query')
name = params.get('name')


if action == "OpenscrapersSettings":
	control.openSettings('0.0', 'script.module.shadowopenscrapers')


elif mode == "OpenscrapersSettings":
	control.openSettings('0.0', 'script.module.shadowopenscrapers')


elif action == 'ShowChangelog':
	from shadowopenscrapers.modules import changelog
	changelog.get()
	control.sleep(200)
	control.openSettings(query, "script.module.shadowopenscrapers")


elif action == 'ShowHelp':
	from shadowopenscrapers.help import help
	help.get(name)
	control.openSettings(query, "script.module.shadowopenscrapers")


elif action == "Defaults":
	sourceList = []
	sourceList = sources_shadowopenscrapers.all_providers
	for i in sourceList:
		source_setting = 'provider.' + i
		value = control.getSettingDefault(source_setting)
		control.setSetting(source_setting, value)
	# xbmc.log('provider-default = %s-%s' % (source_setting, value), 2)
	control.sleep(200)
	control.openSettings(query, "script.module.shadowopenscrapers")


elif action == "toggleAll":
	sourceList = []
	sourceList = sources_shadowopenscrapers.all_providers
	for i in sourceList:
		source_setting = 'provider.' + i
		control.setSetting(source_setting, params['setting'])
	# xbmc.log('All providers = %s' % sourceList,2)
	control.sleep(200)
	control.openSettings(query, "script.module.shadowopenscrapers")


elif action == "toggleAllPaid":
	sourceList = []
	sourceList = sources_shadowopenscrapers.all_paid_providers
	for i in sourceList:
		source_setting = 'provider.' + i
		control.setSetting(source_setting, params['setting'])
	# xbmc.log('All Paid providers = %s' % sourceList,2)
	control.sleep(200)
	control.openSettings(query, "script.module.shadowopenscrapers")


elif action == "toggleAllHosters":
	sourceList = []
	sourceList = sources_shadowopenscrapers.hoster_providers
	for i in sourceList:
		source_setting = 'provider.' + i
		control.setSetting(source_setting, params['setting'])
	# xbmc.log('All Hoster providers = %s' % sourceList,2)
	control.sleep(200)
	control.openSettings(query, "script.module.shadowopenscrapers")


elif action == "toggleAllDebrid":
	sourceList = []
	sourceList = sources_shadowopenscrapers.debrid_providers
	for i in sourceList:
		source_setting = 'provider.' + i
		control.setSetting(source_setting, params['setting'])
	# xbmc.log('All Debrid providers = %s' % sourceList,2)
	control.sleep(200)
	control.openSettings(query, "script.module.shadowopenscrapers")


elif action == "toggleAllTorrent":
	sourceList = []
	sourceList = sources_shadowopenscrapers.torrent_providers
	for i in sourceList:
		source_setting = 'provider.' + i
		control.setSetting(source_setting, params['setting'])
	# xbmc.log('All Torrent providers = %s' % sourceList,2)
	control.sleep(200)
	control.openSettings(query, "script.module.shadowopenscrapers")


elif action == "toggleAllPackTorrent":
	sourceList = []
	from shadowopenscrapers import pack_sources
	sourceList = pack_sources()
	for i in sourceList:
		source_setting = 'provider.' + i
		control.setSetting(source_setting, params['setting'])
	# xbmc.log('All Pack Torrent providers = %s' % sourceList,2)
	control.sleep(200)
	control.openSettings(query, "script.module.shadowopenscrapers")


elif action == "toggleAllForeign":
	sourceList = []
	sourceList = sources_shadowopenscrapers.all_foreign_providers
	for i in sourceList:
		source_setting = 'provider.' + i
		control.setSetting(source_setting, params['setting'])
	# xbmc.log('All Foregin providers = %s' % sourceList,2)
	control.sleep(200)
	control.openSettings(query, "script.module.shadowopenscrapers")


elif action == "toggleAllGerman":
	sourceList = []
	sourceList = sources_shadowopenscrapers.german_providers
	for i in sourceList:
		source_setting = 'provider.' + i
		control.setSetting(source_setting, params['setting'])
	# xbmc.log('All German providers = %s' % sourceList,2)
	control.sleep(200)
	control.openSettings(query, "script.module.shadowopenscrapers")


elif action == "toggleAllSpanish":
	sourceList = []
	sourceList = sources_shadowopenscrapers.spanish_providers
	for i in sourceList:
		source_setting = 'provider.' + i
		control.setSetting(source_setting, params['setting'])
	# xbmc.log('All Spanish providers = %s' % sourceList,2)
	control.sleep(200)
	control.openSettings(query, "script.module.shadowopenscrapers")


elif action == "toggleAllFrench":
	sourceList = []
	sourceList = sources_shadowopenscrapers.french_providers
	for i in sourceList:
		source_setting = 'provider.' + i
		control.setSetting(source_setting, params['setting'])
	# xbmc.log('All French providers = %s' % sourceList,2)
	control.sleep(200)
	control.openSettings(query, "script.module.shadowopenscrapers")


elif action == "toggleAllGreek":
	sourceList = []
	sourceList = sources_shadowopenscrapers.greek_providers
	for i in sourceList:
		source_setting = 'provider.' + i
		control.setSetting(source_setting, params['setting'])
	# xbmc.log('All Greek providers = %s' % sourceList,2)
	control.sleep(200)
	control.openSettings(query, "script.module.shadowopenscrapers")


elif action == "toggleAllKorean":
	sourceList = []
	sourceList = sources_shadowopenscrapers.korean_providers
	for i in sourceList:
		source_setting = 'provider.' + i
		control.setSetting(source_setting, params['setting'])
	# xbmc.log('All Korean providers = %s' % sourceList,2)
	control.sleep(200)
	control.openSettings(query, "script.module.shadowopenscrapers")


elif action == "toggleAllPolish":
	sourceList = []
	sourceList = sources_shadowopenscrapers.polish_providers
	for i in sourceList:
		source_setting = 'provider.' + i
		control.setSetting(source_setting, params['setting'])
	# xbmc.log('All Polish providers = %s' % sourceList,2)
	control.sleep(200)
	control.openSettings(query, "script.module.shadowopenscrapers")


elif action == "toggleAllRussian":
	sourceList = []
	sourceList = sources_shadowopenscrapers.russian_providers
	for i in sourceList:
		source_setting = 'provider.' + i
		control.setSetting(source_setting, params['setting'])
	# xbmc.log('All Russian providers = %s' % sourceList,2)
	control.sleep(200)
	control.openSettings(query, "script.module.shadowopenscrapers")