# -*- coding: UTF-8 -*-
# -Cleaned and Checked on 08-24-2019 by JewBMX in Scrubs.

#  ..#######.########.#######.##....#..######..######.########....###...########.#######.########..######.
#  .##.....#.##.....#.##......###...#.##....#.##....#.##.....#...##.##..##.....#.##......##.....#.##....##
#  .##.....#.##.....#.##......####..#.##......##......##.....#..##...##.##.....#.##......##.....#.##......
#  .##.....#.########.######..##.##.#..######.##......########.##.....#.########.######..########..######.
#  .##.....#.##.......##......##..###.......#.##......##...##..########.##.......##......##...##........##
#  .##.....#.##.......##......##...##.##....#.##....#.##....##.##.....#.##.......##......##....##.##....##
#  ..#######.##.......#######.##....#..######..######.##.....#.##.....#.##.......#######.##.....#..######.

'''
    OpenScrapers Project
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''

import re

import requests

from tikiscrapers.modules import cleantitle
from tikiscrapers.modules import directstream
from tikiscrapers.modules import getSum
from tikiscrapers.modules import source_utils


class source:
    def __init__(self):
        self.priority = 1
        self.language = ['en']  # watchserieshd.co got changed to a different source
        self.domains = ['watchserieshd.cc']  # Old  watchserieshd.io
        self.base_link = 'https://watchserieshd.cc'
        self.search_link = '/series/%s-season-%s-episode-%s'

    def tvshow(self, imdb, tvdb, tvshowtitle, localtvshowtitle, aliases, year):
        try:
            url = cleantitle.geturl(tvshowtitle)
            return url
        except:
            return

    def episode(self, url, imdb, tvdb, title, premiered, season, episode):
        try:
            if not url:
                return
            tvshowtitle = url
            url = self.base_link + self.search_link % (tvshowtitle, season, episode)
            return url
        except:
            return

    def sources(self, url, hostDict, hostprDict):
        try:
            if url is None:
                return sources
            sources = []
            hostDict = hostprDict + hostDict
            r = getSum.get(url)
            match = getSum.findSum(r)
            for url in match:
                if 'vidcloud' in url:
                    result = getSum.get(url)
                    match = getSum.findSum(result)
                    for link in match:
                        link = "https:" + link if not link.startswith('http') else link
                        link = requests.get(link).url if 'vidnode' in link else link
                        valid, host = source_utils.is_host_valid(link, hostDict)
                        if valid:
                            quality, info = source_utils.get_release_quality(link, link)
                            sources.append(
                                {'source': host, 'quality': quality, 'language': 'en', 'info': info, 'url': link,
                                 'direct': False, 'debridonly': False})
                else:
                    valid, host = source_utils.is_host_valid(url, hostDict)
                    if valid:
                        quality, info = source_utils.get_release_quality(url, url)
                        sources.append({'source': host, 'quality': quality, 'language': 'en', 'info': info, 'url': url,
                                        'direct': False, 'debridonly': False})
            return sources
        except:
            return sources

    def resolve(self, url):
        if "google" in url:
            return directstream.googlepass(url)
        elif 'vidcloud' in url:
            r = getSum.get(url)
            url = re.findall("file: '(.+?)'", r)[0]
            return url
        else:
            return url
