#! /usr/bin/python

_strings = {}

if __name__ == "__main__":
    import polib
    po = polib.pofile("resources/language/English/strings.po")
    try:
        import re, subprocess
        r = subprocess.check_output(["grep", "-hnr", "_([\'\"]", "."])
        strings = re.compile("_\([\"'](.*?)[\"']\)", re.IGNORECASE).findall(r)
        translated = [m.msgid.lower().replace("'", "\\'") for m in po]
        missing = set([s for s in strings if s.lower() not in translated])
        if missing:
            ids_range = range(30000, 31000)
            ids_reserved = [int(m.msgctxt[1:]) for m in po]
            ids_available = [x for x in ids_range if x not in ids_reserved]
            print "WARNING: missing translation for '%s'" % missing
            for text in missing:
                id = ids_available.pop(0)
                entry = polib.POEntry(msgid=text, msgstr=u'', msgctxt="#{0}".format(id))
                po.append(entry)
            po.save("resources/language/English/strings.po")
    except: pass
    content = []
    with open(__file__, "r") as me:
        content = me.readlines()
        content = content[:content.index("#GENERATED\n")+1]
    with open(__file__, "w") as f:
        f.writelines(content)
        for m in po:
            line = "_strings['{0}'] = {1}\n".format(m.msgid.lower().replace("'", "\\'"), m.msgctxt.replace("#", "").strip())
            f.write(line)
else:
    def get_string(t):
        import xbmc, xbmcaddon
        ADDON = xbmcaddon.Addon()
        ADDON_ID = ADDON.getAddonInfo("id")
        id = _strings.get(t.lower())
        if not id:
            xbmc.log("LANGUAGE: missing translation for '%s'" % t.lower())
            return t
        elif id in range(30000, 31000) and ADDON_ID.startswith("plugin"): return ADDON.getLocalizedString(id)
        elif id in range(31000, 32000) and ADDON_ID.startswith("skin"): return ADDON.getLocalizedString(id)
        elif id in range(32000, 33000) and ADDON_ID.startswith("script"): return ADDON.getLocalizedString(id)
        elif not id in range(30000, 33000): return xbmc.getLocalizedString(id)
    #setattr(__builtin__, "_", get_string)

# SYSTEM LANGUAGE STRINGS: Only the ones that are available AND unchanged in ["Helix", "Isengard", "Jarvis", "Krypton", "Leia"]
_strings['programs'] = 0
_strings['pictures'] = 1
_strings['music'] = 2
_strings['videos'] = 3
_strings['settings'] = 5
_strings['file manager'] = 7
_strings['weather'] = 8
_strings['kodi media center'] = 9
_strings['monday'] = 11
_strings['tuesday'] = 12
_strings['wednesday'] = 13
_strings['thursday'] = 14
_strings['friday'] = 15
_strings['saturday'] = 16
_strings['sunday'] = 17
_strings['january'] = 21
_strings['february'] = 22
_strings['march'] = 23
_strings['april'] = 24
_strings['may'] = 25
_strings['june'] = 26
_strings['july'] = 27
_strings['august'] = 28
_strings['september'] = 29
_strings['october'] = 30
_strings['november'] = 31
_strings['december'] = 32
_strings['mon'] = 41
_strings['tue'] = 42
_strings['wed'] = 43
_strings['thu'] = 44
_strings['fri'] = 45
_strings['sat'] = 46
_strings['sun'] = 47
_strings['jan'] = 51
_strings['feb'] = 52
_strings['mar'] = 53
_strings['apr'] = 54
_strings['may'] = 55
_strings['jun'] = 56
_strings['jul'] = 57
_strings['aug'] = 58
_strings['sep'] = 59
_strings['oct'] = 60
_strings['nov'] = 61
_strings['dec'] = 62
_strings['n'] = 71
_strings['nne'] = 72
_strings['ne'] = 73
_strings['ene'] = 74
_strings['e'] = 75
_strings['ese'] = 76
_strings['se'] = 77
_strings['sse'] = 78
_strings['s'] = 79
_strings['ssw'] = 80
_strings['sw'] = 81
_strings['wsw'] = 82
_strings['w'] = 83
_strings['wnw'] = 84
_strings['nw'] = 85
_strings['nnw'] = 86
_strings['var'] = 87
_strings['south'] = 88
_strings['north'] = 89
_strings['west'] = 90
_strings['east'] = 91
_strings['variable'] = 92
_strings['view: auto'] = 98
_strings['view: auto big'] = 99
_strings['view: icons'] = 100
_strings['view: list'] = 101
_strings['scan'] = 102
_strings['sort by: name'] = 103
_strings['sort by: date'] = 104
_strings['sort by: size'] = 105
_strings['no'] = 106
_strings['yes'] = 107
_strings['slideshow'] = 108
_strings['create thumbs'] = 109
_strings['create thumbnails'] = 110
_strings['shortcuts'] = 111
_strings['paused'] = 112
_strings['update failed'] = 113
_strings['installation failed'] = 114
_strings['copy'] = 115
_strings['move'] = 116
_strings['delete'] = 117
_strings['rename'] = 118
_strings['new folder'] = 119
_strings['confirm delete'] = 122
_strings['status'] = 126
_strings['objects'] = 127
_strings['general'] = 128
_strings['slideshow'] = 129
_strings['system info'] = 130
_strings['display'] = 131
_strings['albums'] = 132
_strings['artists'] = 133
_strings['songs'] = 134
_strings['genres'] = 135
_strings['playlists'] = 136
_strings['search'] = 137
_strings['temperatures:'] = 139
_strings['cpu:'] = 140
_strings['gpu:'] = 141
_strings['time:'] = 142
_strings['current:'] = 143
_strings['build:'] = 144
_strings['network:'] = 145
_strings['type:'] = 146
_strings['static'] = 147
_strings['dhcp'] = 148
_strings['mac address'] = 149
_strings['ip address'] = 150
_strings['link:'] = 151
_strings['half duplex'] = 152
_strings['full duplex'] = 153
_strings['storage'] = 154
_strings['drive'] = 155
_strings['free'] = 156
_strings['video'] = 157
_strings['free memory'] = 158
_strings['no link'] = 159
_strings['free'] = 160
_strings['unavailable'] = 161
_strings['tray open'] = 162
_strings['reading'] = 163
_strings['no disc'] = 164
_strings['disc present'] = 165
_strings['skin'] = 166
_strings['cancel file operations'] = 167
_strings['%s- %s'] = 168
_strings['resolution'] = 169
_strings['sort title'] = 171
_strings['release date'] = 172
_strings['display 4:3 videos as'] = 173
_strings['moods'] = 175
_strings['styles'] = 176
_strings['song'] = 179
_strings['duration'] = 180
_strings['select album'] = 181
_strings['tracks'] = 182
_strings['review'] = 183
_strings['refresh'] = 184
_strings['searching album'] = 185
_strings['ok'] = 186
_strings['no albums found!'] = 187
_strings['select all'] = 188
_strings['save'] = 190
_strings['shuffle'] = 191
_strings['clear'] = 192
_strings['scan'] = 193
_strings['searching...'] = 194
_strings['select movie:'] = 196
_strings['loading movie details'] = 198
_strings['web interface'] = 199
_strings['audio encoders'] = 200
_strings['tagline'] = 202
_strings['plot outline'] = 203
_strings['votes'] = 205
_strings['cast'] = 206
_strings['plot'] = 207
_strings['play'] = 208
_strings['next'] = 209
_strings['previous'] = 210
_strings['calibrate user interface...'] = 213
_strings['video calibration...'] = 214
_strings['soften'] = 215
_strings['zoom amount'] = 216
_strings['pixel ratio'] = 217
_strings['dvd drive'] = 218
_strings['please insert disc'] = 219
_strings['remote share'] = 220
_strings['network is not connected'] = 221
_strings['cancel'] = 222
_strings['speed'] = 224
_strings['test patterns...'] = 226
_strings['shuffle playlist on load'] = 228
_strings['hdd spindown time'] = 229
_strings['video filters'] = 230
_strings['none'] = 231
_strings['point'] = 232
_strings['linear'] = 233
_strings['anisotropic'] = 234
_strings['quincunx'] = 235
_strings['gaussian cubic'] = 236
_strings['minification'] = 237
_strings['magnification'] = 238
_strings['clear playlist on finish'] = 239
_strings['windowed'] = 242
_strings['full screen'] = 244
_strings['sizing: (%i,%i)->(%i,%i) (zoom x%2.2f) ar:%2.2f:1 (pixels: %2.2f:1) (vshift: %2.2f)'] = 245
_strings['monitor'] = 246
_strings['scripts'] = 247
_strings['language'] = 248
_strings['music'] = 249
_strings['visualisation'] = 250
_strings['select destination directory'] = 251
_strings['stereo upmix'] = 252
_strings['number of channels'] = 253
_strings['dts capable receiver'] = 254
_strings['cddb'] = 255
_strings['fetching cd information'] = 256
_strings['error'] = 257
_strings['enable tag reading'] = 258
_strings['opening'] = 259
_strings['shoutcast'] = 260
_strings['waiting for start...'] = 261
_strings['scripts output'] = 262
_strings['record'] = 264
_strings['stop rec.'] = 265
_strings['sort by: track'] = 266
_strings['sort by: time'] = 267
_strings['sort by: title'] = 268
_strings['sort by: artist'] = 269
_strings['sort by: album'] = 270
_strings['top 100'] = 271
_strings['top-left overscan compensation'] = 272
_strings['bottom-right overscan compensation'] = 273
_strings['subtitle positioning'] = 274
_strings['pixel ratio adjustment'] = 275
_strings['adjust the arrow to change the amount of overscan'] = 276
_strings['adjust the bar to change the subtitles position'] = 277
_strings['adjust the rectangle so it is perfectly square'] = 278
_strings['unable to load settings'] = 279
_strings['using default settings'] = 280
_strings['please check the xml files'] = 281
_strings['found %i items'] = 282
_strings['search results'] = 283
_strings['no results found'] = 284
_strings['preferred audio language'] = 285
_strings['preferred subtitle language'] = 286
_strings['subtitles'] = 287
_strings['font'] = 288
_strings['size'] = 289
_strings['dynamic range compression'] = 290
_strings['video'] = 291
_strings['audio'] = 292
_strings['browse for subtitles'] = 293
_strings['create bookmark'] = 294
_strings['clear bookmarks'] = 296
_strings['audio offset'] = 297
_strings['bookmarks'] = 298
_strings['mp1 capable receiver'] = 300
_strings['mp2 capable receiver'] = 301
_strings['mp3 capable receiver'] = 302
_strings['delay'] = 303
_strings['language'] = 304
_strings['enabled'] = 305
_strings['non-interleaved'] = 306
_strings['original stream\'s language'] = 308
_strings['user interface language'] = 309
_strings['keyboard layouts'] = 310
_strings['(0=auto)'] = 312
_strings['cleaning database'] = 313
_strings['preparing...'] = 314
_strings['database error'] = 315
_strings['searching songs...'] = 316
_strings['cleaned database successfully'] = 317
_strings['cleaning songs...'] = 318
_strings['error cleaning songs'] = 319
_strings['cleaning artists...'] = 320
_strings['error cleaning artists'] = 321
_strings['cleaning genres...'] = 322
_strings['error cleaning genres'] = 323
_strings['cleaning paths...'] = 324
_strings['error cleaning paths'] = 325
_strings['cleaning albums...'] = 326
_strings['error cleaning albums'] = 327
_strings['writing changes...'] = 328
_strings['error writing changes'] = 329
_strings['this may take some time...'] = 330
_strings['compressing database...'] = 331
_strings['error compressing database'] = 332
_strings['do you want to clean the library?'] = 333
_strings['clean library...'] = 334
_strings['start'] = 335
_strings['framerate conversion'] = 336
_strings['output configuration'] = 337
_strings['fixed'] = 338
_strings['optimized'] = 339
_strings['various artists'] = 340
_strings['play disc'] = 341
_strings['movies'] = 342
_strings['adjust framerate'] = 343
_strings['actors'] = 344
_strings['year'] = 345
_strings['maintain original volume on downmix'] = 346
_strings['dts-hd capable receiver'] = 347
_strings['truehd capable receiver'] = 349
_strings['programs'] = 350
_strings['off'] = 351
_strings['dim'] = 352
_strings['black'] = 353
_strings['matrix trails'] = 354
_strings['screensaver mode'] = 356
_strings['shutdown function timer'] = 357
_strings['all albums'] = 358
_strings['recently added albums'] = 359
_strings['screensaver'] = 360
_strings['screensaver dim level'] = 362
_strings['sort by: file'] = 363
_strings['dolby digital (ac3) capable receiver'] = 364
_strings['sort by: name'] = 365
_strings['sort by: year'] = 366
_strings['sort by: rating'] = 367
_strings['imdb'] = 368
_strings['title'] = 369
_strings['thunderstorms'] = 370
_strings['partly'] = 371
_strings['mostly'] = 372
_strings['sunny'] = 373
_strings['cloudy'] = 374
_strings['snow'] = 375
_strings['rain'] = 376
_strings['light'] = 377
_strings['am'] = 378
_strings['pm'] = 379
_strings['showers'] = 380
_strings['few'] = 381
_strings['scattered'] = 382
_strings['wind'] = 383
_strings['strong'] = 384
_strings['fair'] = 385
_strings['clear'] = 386
_strings['clouds'] = 387
_strings['early'] = 388
_strings['shower'] = 389
_strings['flurries'] = 390
_strings['low'] = 391
_strings['medium'] = 392
_strings['high'] = 393
_strings['fog'] = 394
_strings['haze'] = 395
_strings['select location'] = 396
_strings['refresh time'] = 397
_strings['temperature units'] = 398
_strings['speed units'] = 399
_strings['weather'] = 400
_strings['temp'] = 401
_strings['feels like'] = 402
_strings['uv index'] = 403
_strings['wind'] = 404
_strings['dew point'] = 405
_strings['humidity'] = 406
_strings['defaults'] = 409
_strings['accessing weather service'] = 410
_strings['getting weather for:'] = 411
_strings['unable to get weather data'] = 412
_strings['manual'] = 413
_strings['no review for this album'] = 414
_strings['downloading thumbnail...'] = 415
_strings['not available'] = 416
_strings['view: big icons'] = 417
_strings['low'] = 418
_strings['high'] = 419
_strings['keep audio device alive'] = 421
_strings['delete cd information'] = 423
_strings['select'] = 424
_strings['no album information found'] = 425
_strings['no cd information found'] = 426
_strings['disc'] = 427
_strings['please insert the following disc:'] = 429
_strings['sort by: dvd#'] = 430
_strings['no cache'] = 431
_strings['remove movie from library'] = 432
_strings['from %s at %i %s'] = 434
_strings['no optical disc drive detected'] = 435
_strings['you need an optical disc drive to play this video'] = 436
_strings['removable disk'] = 437
_strings['opening file'] = 438
_strings['cache'] = 439
_strings['hard disk'] = 440
_strings['udf'] = 441
_strings['local network'] = 442
_strings['internet'] = 443
_strings['video'] = 444
_strings['audio'] = 445
_strings['dvd'] = 446
_strings['autorun media'] = 447
_strings['dolby digital plus (e-ac3) capable receiver'] = 448
_strings['enabled'] = 449
_strings['columns'] = 450
_strings['row 1 address'] = 451
_strings['row 2 address'] = 452
_strings['row 3 address'] = 453
_strings['row 4 address'] = 454
_strings['rows'] = 455
_strings['mode'] = 456
_strings['switch view'] = 457
_strings['limit sampling rate (khz)'] = 458
_strings['subs'] = 459
_strings['audio stream'] = 460
_strings['[active]'] = 461
_strings['subtitle'] = 462
_strings['backlight'] = 463
_strings['brightness'] = 464
_strings['contrast'] = 465
_strings['gamma'] = 466
_strings['type'] = 467
_strings['move the bar to change the osd position'] = 468
_strings['osd position'] = 469
_strings['credits'] = 470
_strings['off'] = 474
_strings['music only'] = 475
_strings['music & video'] = 476
_strings['unable to load playlist'] = 477
_strings['osd'] = 478
_strings['skin & language'] = 479
_strings['appearance'] = 480
_strings['audio options'] = 481
_strings['about kodi'] = 482
_strings['delete album'] = 485
_strings['repeat'] = 486
_strings['repeat one'] = 487
_strings['repeat folder'] = 488
_strings['- use big icons'] = 491
_strings['resize vobsubs'] = 492
_strings['overall audio headroom'] = 494
_strings['calibration'] = 496
_strings['show file extensions'] = 497
_strings['sort by: type'] = 498
_strings['unable to connect to online lookup service'] = 499
_strings['downloading album information failed'] = 500
_strings['looking for album names...'] = 501
_strings['open'] = 502
_strings['busy'] = 503
_strings['empty'] = 504
_strings['sort by: usage'] = 507
_strings['enable visualisations'] = 510
_strings['enable video mode switching'] = 511
_strings['startup window'] = 512
_strings['home window'] = 513
_strings['manual settings'] = 514
_strings['genre'] = 515
_strings['recently played albums'] = 517
_strings['launch'] = 518
_strings['launch in...'] = 519
_strings['compilations'] = 521
_strings['remove source'] = 522
_strings['switch media'] = 523
_strings['select playlist'] = 524
_strings['new playlist...'] = 525
_strings['add to playlist'] = 526
_strings['manually add to library'] = 527
_strings['enter title'] = 528
_strings['error: duplicate title'] = 529
_strings['select genre'] = 530
_strings['new genre'] = 531
_strings['manual addition'] = 532
_strings['enter genre'] = 533
_strings['view: %s'] = 534
_strings['list'] = 535
_strings['icons'] = 536
_strings['big list'] = 537
_strings['big icons'] = 538
_strings['wide'] = 539
_strings['big wide'] = 540
_strings['album icons'] = 541
_strings['dvd icons'] = 542
_strings['dvd'] = 543
_strings['media info'] = 544
_strings['audio output device'] = 545
_strings['passthrough output device'] = 546
_strings['no biography for this artist'] = 547
_strings['downmix multichannel audio to stereo'] = 548
_strings['number'] = 549
_strings['sort by: %s'] = 550
_strings['name'] = 551
_strings['date'] = 552
_strings['size'] = 553
_strings['track'] = 554
_strings['time'] = 555
_strings['title'] = 556
_strings['artist'] = 557
_strings['album'] = 558
_strings['playlist'] = 559
_strings['id'] = 560
_strings['file'] = 561
_strings['year'] = 562
_strings['rating'] = 563
_strings['type'] = 564
_strings['usage'] = 565
_strings['album artist'] = 566
_strings['play count'] = 567
_strings['last played'] = 568
_strings['comment'] = 569
_strings['date added'] = 570
_strings['default'] = 571
_strings['studio'] = 572
_strings['path'] = 573
_strings['country'] = 574
_strings['in progress'] = 575
_strings['times played'] = 576
_strings['sort direction'] = 580
_strings['sort method'] = 581
_strings['view mode'] = 582
_strings['remember views for different folders'] = 583
_strings['ascending'] = 584
_strings['descending'] = 585
_strings['edit playlist'] = 586
_strings['filter'] = 587
_strings['cancel party mode'] = 588
_strings['party mode'] = 589
_strings['random'] = 590
_strings['off'] = 591
_strings['one'] = 592
_strings['all'] = 593
_strings['off'] = 594
_strings['repeat: off'] = 595
_strings['repeat: one'] = 596
_strings['repeat: all'] = 597
_strings['rip audio cd'] = 600
_strings['medium'] = 601
_strings['standard'] = 602
_strings['extreme'] = 603
_strings['constant bitrate'] = 604
_strings['ripping...'] = 605
_strings['to:'] = 607
_strings['rip audio track'] = 610
_strings['enter number'] = 611
_strings['bits/sample'] = 612
_strings['sample rate'] = 613
_strings['virtual folder'] = 614
_strings['audio cds'] = 620
_strings['encoder'] = 621
_strings['quality'] = 622
_strings['bitrate'] = 623
_strings['include track number'] = 624
_strings['all songs of'] = 625
_strings['in progress tv shows'] = 626
_strings['view mode'] = 629
_strings['normal'] = 630
_strings['zoom'] = 631
_strings['stretch 4:3'] = 632
_strings['stretch 16:9'] = 634
_strings['custom'] = 636
_strings['replaygain'] = 637
_strings['use track levels'] = 639
_strings['use album levels'] = 640
_strings['need to unpack a big file. continue?'] = 645
_strings['remove from library'] = 646
_strings['export video library'] = 647
_strings['import video library'] = 648
_strings['importing'] = 649
_strings['exporting'] = 650
_strings['browse for library'] = 651
_strings['years'] = 652
_strings['update library'] = 653
_strings['browse for executable'] = 655
_strings['browse for playlist'] = 656
_strings['browse for folder'] = 657
_strings['song information'] = 658
_strings['non-linear stretch'] = 659
_strings['volume amplification'] = 660
_strings['choose export folder'] = 661
_strings['this file is no longer available.'] = 662
_strings['would you like to remove it from the library?'] = 663
_strings['compression level'] = 665
_strings['enable component-specific logging'] = 666
_strings['specify component-specific logging...'] = 668
_strings['cleaning up library'] = 700
_strings['removing old songs from the library'] = 701
_strings['this path has been scanned before'] = 702
_strings['network'] = 705
_strings['server'] = 706
_strings['internet protocol (ip)'] = 711
_strings['invalid port specified. value must be between 1 and 65535.'] = 712
_strings['http proxy'] = 713
_strings['assignment'] = 715
_strings['automatic (dhcp)'] = 716
_strings['ip address'] = 719
_strings['netmask'] = 720
_strings['default gateway'] = 721
_strings['dns server'] = 722
_strings['save & restart'] = 723
_strings['invalid address specified. value must be aaa.bbb.ccc.ddd'] = 724
_strings['with numbers between 0 and 255.'] = 725
_strings['changes not saved. continue without saving?'] = 726
_strings['web server'] = 727
_strings['ftp server'] = 728
_strings['port'] = 730
_strings['save & apply'] = 732
_strings['password'] = 733
_strings['no pass'] = 734
_strings['character set'] = 735
_strings['style'] = 736
_strings['colour'] = 737
_strings['normal'] = 738
_strings['bold'] = 739
_strings['italics'] = 740
_strings['bold italics'] = 741
_strings['white'] = 742
_strings['yellow'] = 743
_strings['files'] = 744
_strings['error loading image'] = 747
_strings['edit path'] = 748
_strings['mirror image'] = 749
_strings['are you sure?'] = 750
_strings['removing source'] = 751
_strings['add program link'] = 754
_strings['edit program path'] = 755
_strings['edit program name'] = 756
_strings['edit path depth'] = 757
_strings['view: big list'] = 759
_strings['yellow'] = 760
_strings['white'] = 761
_strings['blue'] = 762
_strings['bright green'] = 763
_strings['yellow green'] = 764
_strings['cyan'] = 765
_strings['light grey'] = 766
_strings['grey'] = 767
_strings['error %i: share not available'] = 770
_strings['seeking'] = 773
_strings['slideshow folder'] = 774
_strings['network interface'] = 775
_strings['wireless network name (essid)'] = 776
_strings['wireless password'] = 777
_strings['wireless security'] = 778
_strings['save and apply network interface settings'] = 779
_strings['no encryption'] = 780
_strings['wep'] = 781
_strings['wpa'] = 782
_strings['wpa2'] = 783
_strings['applying network interface settings. please wait.'] = 784
_strings['network interface restarted successfully.'] = 785
_strings['network interface did not start successfully.'] = 786
_strings['interface disabled'] = 787
_strings['network interface disabled successfully.'] = 788
_strings['wireless network name (essid)'] = 789
_strings['remote control'] = 790
_strings['port'] = 792
_strings['port range'] = 793
_strings['initial repeat delay (ms)'] = 795
_strings['continuous repeat delay (ms)'] = 796
_strings['maximum number of clients'] = 797
_strings['internet access'] = 798
_strings['%s of %s available'] = 802
_strings['invalid port number entered'] = 850
_strings['valid port range is 1-65535'] = 851
_strings['valid port range is 1024-65535'] = 852
_strings['preview'] = 1000
_strings['unable to connect'] = 1001
_strings['ip address'] = 1006
_strings['add network location'] = 1007
_strings['protocol'] = 1008
_strings['server address'] = 1009
_strings['server name'] = 1010
_strings['remote path'] = 1011
_strings['shared folder'] = 1012
_strings['port'] = 1013
_strings['username'] = 1014
_strings['browse for network server'] = 1015
_strings['enter the network address of the server'] = 1016
_strings['enter the path on the server'] = 1017
_strings['enter the port number'] = 1018
_strings['enter the username'] = 1019
_strings['enter the paths or browse for the media locations.'] = 1021
_strings['browse for new share'] = 1023
_strings['browse'] = 1024
_strings['add source'] = 1026
_strings['edit source'] = 1027
_strings['enter the new label'] = 1029
_strings['browse for image'] = 1030
_strings['browse for image folder'] = 1031
_strings['add network location...'] = 1032
_strings['browse for file'] = 1033
_strings['submenu'] = 1034
_strings['enable submenu buttons'] = 1035
_strings['favourites'] = 1036
_strings['loading directory'] = 1040
_strings['retrieved %i items'] = 1041
_strings['retrieved %i of %i items'] = 1042
_strings['set plug-in thumb'] = 1044
_strings['access points'] = 1046
_strings['other...'] = 1047
_strings['username'] = 1048
_strings['script settings'] = 1049
_strings['singles'] = 1050
_strings['enter web address'] = 1051
_strings['proxy type'] = 1180
_strings['http'] = 1181
_strings['socks4'] = 1182
_strings['socks4a'] = 1183
_strings['socks5'] = 1184
_strings['smb client'] = 1200
_strings['workgroup'] = 1202
_strings['default username'] = 1203
_strings['default password'] = 1204
_strings['wins server'] = 1207
_strings['mount smb shares'] = 1208
_strings['remove'] = 1210
_strings['music'] = 1211
_strings['video'] = 1212
_strings['pictures'] = 1213
_strings['files'] = 1214
_strings['music & video '] = 1215
_strings['music & pictures'] = 1216
_strings['music & files'] = 1217
_strings['video & pictures'] = 1218
_strings['video & files'] = 1219
_strings['pictures & files'] = 1220
_strings['music & video & pictures'] = 1221
_strings['music & video & pictures & files'] = 1222
_strings['disabled'] = 1223
_strings['files & music & video'] = 1226
_strings['files & pictures & music'] = 1227
_strings['files & pictures & video'] = 1228
_strings['music & programs'] = 1229
_strings['video & programs'] = 1230
_strings['pictures & programs'] = 1231
_strings['music & video & pictures & programs'] = 1232
_strings['programs & video & music'] = 1233
_strings['programs & pictures & music'] = 1234
_strings['programs & pictures & video'] = 1235
_strings['zeroconf'] = 1259
_strings['allow volume control'] = 1269
_strings['device name'] = 1271
_strings['use password protection'] = 1272
_strings['airplay'] = 1273
_strings['airtunes'] = 1274
_strings['filter %s'] = 1275
_strings['custom audio device'] = 1300
_strings['custom passthrough device'] = 1301
_strings['temperature'] = 1375
_strings['pressure'] = 1376
_strings['proximity'] = 1377
_strings['intensity'] = 1378
_strings['ragged'] = 1379
_strings['very'] = 1380
_strings['extreme'] = 1381
_strings['whirls'] = 1382
_strings['broken'] = 1384
_strings['tornado'] = 1385
_strings['tropical'] = 1386
_strings['hurricane'] = 1387
_strings['cold'] = 1388
_strings['windy'] = 1389
_strings['settings'] = 1390
_strings['breeze'] = 1391
_strings['gentle'] = 1392
_strings['high wind, near gale'] = 1393
_strings['severe'] = 1394
_strings['violent'] = 1395
_strings['drifting'] = 1396
_strings['and'] = 1397
_strings['freezing'] = 1398
_strings['late'] = 1399
_strings['isolated'] = 1400
_strings['thundershowers'] = 1401
_strings['thunder'] = 1402
_strings['sun'] = 1403
_strings['heavy'] = 1404
_strings['in'] = 1405
_strings['the'] = 1406
_strings['vicinity'] = 1407
_strings['ice'] = 1408
_strings['crystals'] = 1409
_strings['calm'] = 1410
_strings['with'] = 1411
_strings['windy'] = 1412
_strings['patches'] = 1413
_strings['thunderstorm'] = 1414
_strings['drizzle'] = 1415
_strings['foggy'] = 1416
_strings['grains'] = 1417
_strings['thunderstorms'] = 1418
_strings['shallow'] = 1419
_strings['moderate'] = 1420
_strings['windy'] = 1422
_strings['mist'] = 1423
_strings['overcast'] = 1424
_strings['pellets'] = 1425
_strings['hail'] = 1426
_strings['smoke'] = 1427
_strings['volcanic'] = 1428
_strings['ash'] = 1429
_strings['widespread'] = 1430
_strings['dust'] = 1431
_strings['sand'] = 1432
_strings['spray'] = 1433
_strings['whirls'] = 1434
_strings['sandstorm'] = 1435
_strings['blowing'] = 1436
_strings['pellet'] = 1437
_strings['small'] = 1438
_strings['and'] = 1439
_strings['sleet'] = 1440
_strings['with'] = 1441
_strings['chance'] = 1442
_strings['of'] = 1443
_strings['funnel'] = 1444
_strings['cloud'] = 1445
_strings['unknown'] = 1446
_strings['precipitation'] = 1448
_strings['partial'] = 1449
_strings['put display to sleep when idle'] = 1450
_strings['runtime'] = 2050
_strings['empty list'] = 2080
_strings['went back to parent list because the active list has been emptied'] = 2081
_strings['home'] = 10000
_strings['programs'] = 10001
_strings['pictures'] = 10002
_strings['file manager'] = 10003
_strings['settings'] = 10004
_strings['music'] = 10005
_strings['videos'] = 10006
_strings['system information'] = 10007
_strings['settings - general'] = 10008
_strings['settings - screen'] = 10009
_strings['settings - pictures'] = 10012
_strings['settings - programs'] = 10013
_strings['settings - weather'] = 10014
_strings['settings - music'] = 10015
_strings['settings - system'] = 10016
_strings['settings - videos'] = 10017
_strings['settings - network'] = 10018
_strings['settings - appearance'] = 10019
_strings['scripts'] = 10020
_strings['videos'] = 10025
_strings['login screen'] = 10029
_strings['settings - profiles'] = 10034
_strings['reset'] = 10035
_strings['basic'] = 10036
_strings['standard'] = 10037
_strings['advanced'] = 10038
_strings['expert'] = 10039
_strings['add-on browser'] = 10040
_strings['reset above settings to default'] = 10041
_strings['are you sure you want to reset the settings in this category?'] = 10042
_strings['help'] = 10043
_strings['no help available'] = 10044
_strings['resets all the visible settings to their default values.'] = 10045
_strings['no categories available'] = 10046
_strings['try changing the setting level to see additional categories and settings.'] = 10047
_strings['progress dialogue'] = 10101
_strings['file browser'] = 10126
_strings['network setup'] = 10128
_strings['media source'] = 10129
_strings['profile settings'] = 10130
_strings['lock settings'] = 10131
_strings['content settings'] = 10132
_strings['favourites'] = 10134
_strings['smart playlist editor'] = 10136
_strings['smart playlist rule editor'] = 10137
_strings['add-on settings'] = 10140
_strings['looking for subtitles...'] = 10210
_strings['looking for or caching subtitles...'] = 10211
_strings['terminating'] = 10212
_strings['buffering'] = 10213
_strings['opening stream'] = 10214
_strings['playlist editor'] = 10503
_strings['top 100 songs'] = 10504
_strings['top 100 albums'] = 10505
_strings['programs'] = 10506
_strings['configuration'] = 10507
_strings['weather forecast'] = 10508
_strings['network gaming'] = 10509
_strings['extensions'] = 10510
_strings['system info'] = 10511
_strings['music - library'] = 10516
_strings['select dialogue'] = 12000
_strings['dialogue ok'] = 12002
_strings['fullscreen video'] = 12005
_strings['audio visualisation'] = 12006
_strings['file stacking dialogue'] = 12008
_strings['rebuild index...'] = 12009
_strings['return to music window'] = 12010
_strings['return to videos window'] = 12011
_strings['resume from %s'] = 12022
_strings['0'] = 12310
_strings['1'] = 12311
_strings['2'] = 12312
_strings['3'] = 12313
_strings['4'] = 12314
_strings['5'] = 12315
_strings['6'] = 12316
_strings['7'] = 12317
_strings['8'] = 12318
_strings['9'] = 12319
_strings['c'] = 12320
_strings['*'] = 12322
_strings['locked! enter code...'] = 12325
_strings['enter password'] = 12326
_strings['enter master code'] = 12327
_strings['enter unlock code'] = 12328
_strings['enter gamepad button combo and'] = 12330
_strings['set lock'] = 12332
_strings['unlock'] = 12333
_strings['reset lock'] = 12334
_strings['remove lock'] = 12335
_strings['numeric password'] = 12337
_strings['gamepad button combo'] = 12338
_strings['full-text password'] = 12339
_strings['enter new password'] = 12340
_strings['incorrect password,'] = 12342
_strings['retries left '] = 12343
_strings['passwords entered did not match.'] = 12344
_strings['access denied'] = 12345
_strings['password retry limit exceeded.'] = 12346
_strings['the system will now power down.'] = 12347
_strings['item locked'] = 12348
_strings['reactivate lock'] = 12353
_strings['change lock'] = 12356
_strings['source lock'] = 12357
_strings['password entry was blank. try again.'] = 12358
_strings['master lock'] = 12360
_strings['settings & file manager'] = 12373
_strings['amount of time to display each image'] = 12378
_strings['use pan and zoom effects'] = 12379
_strings['system uptime'] = 12390
_strings['minutes'] = 12391
_strings['hours'] = 12392
_strings['days'] = 12393
_strings['total uptime'] = 12394
_strings['battery level'] = 12395
_strings['weather'] = 12600
_strings['screensaver'] = 12900
_strings['fullscreen osd'] = 12901
_strings['system'] = 13000
_strings['video only'] = 13002
_strings['- delay'] = 13003
_strings['- minimum file duration'] = 13004
_strings['shutdown'] = 13005
_strings['shutdown function'] = 13008
_strings['quit'] = 13009
_strings['hibernate'] = 13010
_strings['suspend'] = 13011
_strings['exit'] = 13012
_strings['reboot'] = 13013
_strings['minimise'] = 13014
_strings['power button action'] = 13015
_strings['inhibit idle shutdown'] = 13017
_strings['allow idle shutdown'] = 13018
_strings['is another session active, perhaps over ssh?'] = 13020
_strings['joystick plugged'] = 13024
_strings['joystick unplugged'] = 13025
_strings['waiting for network to connect...'] = 13028
_strings['waiting for server to wake up...'] = 13030
_strings['extended wait for server to wake up...'] = 13031
_strings['waiting for services to launch...'] = 13032
_strings['updated for %s'] = 13034
_strings['found for %s'] = 13035
_strings['failed for %s'] = 13036
_strings['running low on battery'] = 13050
_strings['flicker filter'] = 13100
_strings['let driver choose (requires restart)'] = 13101
_strings['disabled'] = 13106
_strings['enabled during video playback'] = 13107
_strings['always enabled'] = 13108
_strings['would you like to keep this change?'] = 13111
_strings['high quality upscaling'] = 13112
_strings['disabled'] = 13113
_strings['enabled for sd content'] = 13114
_strings['always enabled'] = 13115
_strings['upscaling method'] = 13116
_strings['bicubic'] = 13117
_strings['lanczos'] = 13118
_strings['sinc'] = 13119
_strings['vdpau'] = 13120
_strings['keep skin?'] = 13123
_strings['blank other displays'] = 13130
_strings['disabled'] = 13131
_strings['blank displays'] = 13132
_strings['active connections detected!'] = 13140
_strings['change apple remote mode?'] = 13144
_strings['subnet mask'] = 13159
_strings['gateway'] = 13160
_strings['primary dns'] = 13161
_strings['initialise failed'] = 13162
_strings['never'] = 13170
_strings['immediately'] = 13171
_strings['after %i secs'] = 13172
_strings['hdd install date:'] = 13173
_strings['hdd power cycle count:'] = 13174
_strings['profiles'] = 13200
_strings['delete profile "%s"?'] = 13201
_strings['last loaded profile:'] = 13204
_strings['unknown'] = 13205
_strings['overwrite'] = 13206
_strings['alarm clock'] = 13208
_strings['alarm clock interval (in minutes)'] = 13209
_strings['started, alarm in %im'] = 13210
_strings['alarm!'] = 13211
_strings['cancelled with %im%is left'] = 13212
_strings['%2.0fm'] = 13213
_strings['%2.0fs'] = 13214
_strings['search for subtitles in rars'] = 13249
_strings['browse for subtitle...'] = 13250
_strings['move item'] = 13251
_strings['move item here'] = 13252
_strings['cancel move'] = 13253
_strings['hardware:'] = 13270
_strings['connected, but no dns is available.'] = 13274
_strings['dvd-rom'] = 13276
_strings['storage'] = 13277
_strings['default'] = 13278
_strings['network'] = 13279
_strings['video'] = 13280
_strings['hardware'] = 13281
_strings['operating system:'] = 13283
_strings['cpu speed:'] = 13284
_strings['video encoder:'] = 13286
_strings['screen resolution:'] = 13287
_strings['a/v cable:'] = 13292
_strings['dvd region:'] = 13294
_strings['internet:'] = 13295
_strings['connected'] = 13296
_strings['not connected. check network settings.'] = 13297
_strings['target temperature'] = 13299
_strings['fan speed'] = 13300
_strings['auto temperature control'] = 13301
_strings['fan speed override'] = 13302
_strings['fonts'] = 13303
_strings['enable flipping bi-directional strings'] = 13304
_strings['show rss news feeds'] = 13305
_strings['show parent folder items'] = 13306
_strings['track naming template'] = 13307
_strings['zoom effect'] = 13310
_strings['float effect'] = 13311
_strings['black bar reduction'] = 13312
_strings['restart'] = 13313
_strings['crossfade between songs'] = 13314
_strings['regenerate thumbnails'] = 13315
_strings['recursive thumbnails'] = 13316
_strings['view slideshow'] = 13317
_strings['recursive slideshow'] = 13318
_strings['randomise'] = 13319
_strings['stereo'] = 13320
_strings['left only'] = 13321
_strings['right only'] = 13322
_strings['background transparency'] = 13324
_strings['foreground transparency'] = 13325
_strings['a/v delay'] = 13326
_strings['%s not found'] = 13328
_strings['error opening %s'] = 13329
_strings['unable to load %s'] = 13330
_strings['error: out of memory'] = 13331
_strings['move up'] = 13332
_strings['move down'] = 13333
_strings['edit label'] = 13334
_strings['make default'] = 13335
_strings['remove button'] = 13336
_strings['leave as is'] = 13340
_strings['green'] = 13341
_strings['orange'] = 13342
_strings['red'] = 13343
_strings['cycle'] = 13344
_strings['switch led off on playback'] = 13345
_strings['movie information'] = 13346
_strings['queue item'] = 13347
_strings['search imdb...'] = 13348
_strings['scan for new content'] = 13349
_strings['current playlist'] = 13350
_strings['album information'] = 13351
_strings['scan item to library'] = 13352
_strings['stop scanning'] = 13353
_strings['render method'] = 13354
_strings['low quality pixel shader'] = 13355
_strings['hardware overlays'] = 13356
_strings['high quality pixel shader'] = 13357
_strings['play item'] = 13358
_strings['set artist thumb'] = 13359
_strings['automatically generate thumbnails'] = 13360
_strings['enable voice'] = 13361
_strings['enable device'] = 13375
_strings['volume'] = 13376
_strings['default view mode'] = 13377
_strings['default brightness'] = 13378
_strings['default contrast'] = 13379
_strings['default gamma'] = 13380
_strings['resume video'] = 13381
_strings['voice mask - port 1'] = 13382
_strings['voice mask - port 2'] = 13383
_strings['voice mask - port 3'] = 13384
_strings['voice mask - port 4'] = 13385
_strings['use time based seeking'] = 13386
_strings['track naming template - right'] = 13387
_strings['preset'] = 13388
_strings['there are no presets available\nfor this visualisation'] = 13389
_strings['there are no settings available\nfor this visualisation'] = 13390
_strings['use visualisation if playing audio'] = 13392
_strings['calculate size'] = 13393
_strings['calculating folder size'] = 13394
_strings['video settings'] = 13395
_strings['audio and subtitle settings'] = 13396
_strings['enable subtitles'] = 13397
_strings['shortcuts'] = 13398
_strings['crossfade between songs on the same album'] = 13400
_strings['browse for %s'] = 13401
_strings['show track position'] = 13402
_strings['clear default'] = 13403
_strings['resume'] = 13404
_strings['get thumb'] = 13405
_strings['picture information'] = 13406
_strings['%s presets'] = 13407
_strings['(imdb user rating)'] = 13408
_strings['top 250'] = 13409
_strings['tune in on last.fm'] = 13410
_strings['minimum fan speed'] = 13411
_strings['play from here'] = 13412
_strings['downloading'] = 13413
_strings['render method'] = 13415
_strings['auto detect'] = 13416
_strings['basic shaders (arb)'] = 13417
_strings['advanced shaders (glsl)'] = 13418
_strings['software'] = 13419
_strings['remove safely'] = 13420
_strings['vdpau'] = 13421
_strings['start slideshow here'] = 13422
_strings['remember for this path'] = 13423
_strings['play only this'] = 13434
_strings['use mpeg-2 vdpau'] = 13441
_strings['use mpeg-4 vdpau'] = 13443
_strings['use vc-1 vdpau'] = 13445
_strings['use mpeg-2 vaapi'] = 13447
_strings['use mpeg-4 vaapi'] = 13449
_strings['enable this option to use hardware acceleration for the mpeg-4 codec. if disabled the cpu will be used instead.'] = 13450
_strings['use vc-1 vaapi'] = 13451
_strings['prefer vaapi render method'] = 13457
_strings['use omxplayer for decoding of video files.'] = 13459
_strings['resample quality'] = 13505
_strings['medium'] = 13507
_strings['high'] = 13508
_strings['sync playback to display'] = 13510
_strings['choose art'] = 13511
_strings['current art'] = 13512
_strings['remote art'] = 13513
_strings['local art'] = 13514
_strings['no art'] = 13515
_strings['add art'] = 13516
_strings['off'] = 13551
_strings['%d minute'] = 13554
_strings['%d minutes'] = 13555
_strings['allow start of kodi using the remote'] = 13602
_strings['sequence delay time'] = 13603
_strings['disabled'] = 13610
_strings['standard'] = 13611
_strings['stack'] = 14000
_strings['unstack'] = 14001
_strings['downloading playlist file...'] = 14003
_strings['downloading streams list...'] = 14004
_strings['parsing streams list...'] = 14005
_strings['downloading streams list failed'] = 14006
_strings['downloading playlist file failed'] = 14007
_strings['games directory'] = 14009
_strings['auto switch to thumbs based on'] = 14010
_strings['enable auto switching to thumbs view'] = 14011
_strings['- use large icons'] = 14012
_strings['- switch based on'] = 14013
_strings['- percentage'] = 14014
_strings['no files and at least one thumb'] = 14015
_strings['at least one file and thumb'] = 14016
_strings['percentage of thumbs'] = 14017
_strings['view options'] = 14018
_strings['change area code 1'] = 14019
_strings['change area code 2'] = 14020
_strings['change area code 3'] = 14021
_strings['library'] = 14022
_strings['no tv'] = 14023
_strings['enter the nearest large town'] = 14024
_strings['video/audio/dvd cache - hard disk'] = 14025
_strings['video cache - dvd-rom'] = 14026
_strings['video cache - internet'] = 14028
_strings['audio cache - dvd-rom'] = 14030
_strings['audio cache - internet'] = 14032
_strings['dvd cache - dvd-rom'] = 14034
_strings['services'] = 14036
_strings['network settings changed'] = 14038
_strings['internet connection bandwidth limitation'] = 14041
_strings['- shutdown while playing'] = 14043
_strings['%i min'] = 14044
_strings['%i sec'] = 14045
_strings['%i ms'] = 14046
_strings['%i %%'] = 14047
_strings['%i kbps'] = 14048
_strings['%i kb'] = 14049
_strings['%i.0 db'] = 14050
_strings['time format'] = 14051
_strings['date format'] = 14052
_strings['gui filters'] = 14053
_strings['%2.1f db'] = 14054
_strings['use background scanning'] = 14055
_strings['stop scan'] = 14056
_strings['film grain effect'] = 14058
_strings['search for thumbnails on remote shares'] = 14059
_strings['unknown type cache - internet'] = 14060
_strings['auto'] = 14061
_strings['enter username for'] = 14062
_strings['date & time'] = 14063
_strings['set date'] = 14064
_strings['set time'] = 14065
_strings['enter the date in dd/mm/yyyy format'] = 14067
_strings['enter the ip address'] = 14068
_strings['apply these settings now?'] = 14069
_strings['apply changes now'] = 14070
_strings['allow file renaming and deletion'] = 14071
_strings['set timezone'] = 14074
_strings['use daylight saving time'] = 14075
_strings['add to favourites'] = 14076
_strings['remove from favourites'] = 14077
_strings['colours'] = 14078
_strings['timezone country'] = 14079
_strings['timezone'] = 14080
_strings['file lists'] = 14081
_strings['queue songs on selection'] = 14084
_strings['playback'] = 14086
_strings['discs'] = 14087
_strings['play dvds automatically'] = 14088
_strings['font to use for text subtitles'] = 14089
_strings['international'] = 14090
_strings['character set'] = 14091
_strings['security'] = 14093
_strings['power saving'] = 14095
_strings['rip'] = 14096
_strings['play'] = 14098
_strings['stop ripping cd'] = 14100
_strings['blu-ray playback mode'] = 14102
_strings['play main movie'] = 14103
_strings['show simplified menu'] = 14104
_strings['unavailable source'] = 15012
_strings['what would you like to do with media items from %s'] = 15013
_strings['keep'] = 15014
_strings['remove'] = 15015
_strings['games'] = 15016
_strings['add'] = 15019
_strings['password'] = 15052
_strings['library'] = 15100
_strings['database'] = 15101
_strings['* all albums'] = 15102
_strings['* all artists'] = 15103
_strings['* all songs'] = 15104
_strings['* all genres'] = 15105
_strings['buffering...'] = 15107
_strings['skin default'] = 15109
_strings['larger font size'] = 15110
_strings['theme'] = 15111
_strings['default theme'] = 15112
_strings['last.fm'] = 15200
_strings['connected'] = 15207
_strings['not connected'] = 15208
_strings['play using...'] = 15213
_strings['use smoothed a/v synchronisation'] = 15214
_strings['hide file names in thumbs view'] = 15215
_strings['play in party mode'] = 15216
_strings['path not found or invalid'] = 15300
_strings['no servers found'] = 15302
_strings['workgroup not found'] = 15303
_strings['opening multi-path source'] = 15310
_strings['path:'] = 15311
_strings['general'] = 16000
_strings['internet lookup'] = 16002
_strings['player'] = 16003
_strings['play media from disc'] = 16004
_strings['enter new title'] = 16008
_strings['enter the movie name'] = 16009
_strings['enter the profile name'] = 16010
_strings['enter the album name'] = 16011
_strings['enter the playlist name'] = 16012
_strings['enter new filename'] = 16013
_strings['enter folder name'] = 16014
_strings['enter directory'] = 16015
_strings['available options: %a, %t, %n, %b, %d, %g, %y, %f, %s'] = 16016
_strings['enter search string'] = 16017
_strings['none'] = 16018
_strings['auto select'] = 16019
_strings['bob'] = 16021
_strings['cancelling...'] = 16024
_strings['enter the artist name'] = 16025
_strings['playback failed'] = 16026
_strings['enter value'] = 16028
_strings['party mode aborted.'] = 16030
_strings['no matching songs in the library.'] = 16031
_strings['party mode playlist'] = 16035
_strings['deinterlace video'] = 16037
_strings['deinterlace method'] = 16038
_strings['off'] = 16039
_strings['on'] = 16041
_strings['unwatched'] = 16101
_strings['watched'] = 16102
_strings['mark as watched'] = 16103
_strings['mark as unwatched'] = 16104
_strings['edit title'] = 16105
_strings['manage...'] = 16106
_strings['edit sort title'] = 16107
_strings['operation was aborted'] = 16200
_strings['copy failed'] = 16201
_strings['move failed'] = 16203
_strings['delete failed'] = 16205
_strings['video scaling method'] = 16300
_strings['nearest neighbour'] = 16301
_strings['bilinear'] = 16302
_strings['bicubic'] = 16303
_strings['lanczos2'] = 16304
_strings['lanczos3'] = 16305
_strings['sinc8'] = 16306
_strings['bicubic (software)'] = 16307
_strings['lanczos (software)'] = 16308
_strings['sinc (software)'] = 16309
_strings['temporal'] = 16310
_strings['auto'] = 16316
_strings['dxva'] = 16319
_strings['spline36'] = 16322
_strings['vdpau - bob'] = 16325
_strings['mmal - advanced'] = 16330
_strings['mmal - bob'] = 16332
_strings['post-processing'] = 16400
_strings['display sleep timeout'] = 17500
_strings['%i mbyte'] = 17997
_strings['%i hours'] = 17998
_strings['%i days'] = 17999
_strings['switch to channel'] = 19000
_strings['or use phrases to find an exact match, like \"the wizard of oz\".'] = 19002
_strings['find similar'] = 19003
_strings['pvr stream information'] = 19005
_strings['receiving device'] = 19006
_strings['device status'] = 19007
_strings['signal quality'] = 19008
_strings['snr'] = 19009
_strings['ber'] = 19010
_strings['unc'] = 19011
_strings['free to air'] = 19013
_strings['fixed'] = 19014
_strings['encryption'] = 19015
_strings['recordings'] = 19017
_strings['folder with channel icons'] = 19018
_strings['channels'] = 19019
_strings['tv'] = 19020
_strings['radio'] = 19021
_strings['hidden'] = 19022
_strings['tv channels'] = 19023
_strings['radio channels'] = 19024
_strings['upcoming recordings'] = 19025
_strings['add timer...'] = 19026
_strings['no search results'] = 19027
_strings['channel'] = 19029
_strings['now'] = 19030
_strings['next'] = 19031
_strings['timeline'] = 19032
_strings['information'] = 19033
_strings['show signal quality'] = 19037
_strings['not supported by the pvr backend.'] = 19038
_strings['are you sure you want to hide this channel?'] = 19039
_strings['are you sure you want to rename this recording?'] = 19041
_strings['are you sure you want to rename this timer?'] = 19042
_strings['recording'] = 19043
_strings['new channel'] = 19046
_strings['show channel'] = 19049
_strings['show visible channels'] = 19050
_strings['show hidden channels'] = 19051
_strings['move channel to:'] = 19052
_strings['recording information'] = 19053
_strings['hide channel'] = 19054
_strings['no information available'] = 19055
_strings['new timer'] = 19056
_strings['timer enabled'] = 19058
_strings['stop recording'] = 19059
_strings['delete timer'] = 19060
_strings['add timer'] = 19061
_strings['sort by: channel'] = 19062
_strings['go to end'] = 19064
_strings['channel icons'] = 19066
_strings['this event is already being recorded.'] = 19067
_strings['go to now'] = 19070
_strings['delay channel switch'] = 19073
_strings['unknown channel %u'] = 19085
_strings['service'] = 19099
_strings['mux'] = 19100
_strings['provider'] = 19101
_strings['please switch to another channel.'] = 19102
_strings['go to channel'] = 19103
_strings['enter the name of the folder for the recording'] = 19104
_strings['please select a channel'] = 19105
_strings['next timer on'] = 19106
_strings['at'] = 19107
_strings['delete this recording?'] = 19112
_strings['delete all recordings in this folder?'] = 19113
_strings['version'] = 19114
_strings['address'] = 19115
_strings['disksize'] = 19116
_strings['search for channels'] = 19117
_strings['client number'] = 19120
_strings['avoid repeats'] = 19121
_strings['this timer is still recording. are you sure you want to delete this timer?'] = 19122
_strings['free to air channels only'] = 19123
_strings['ignore present timers'] = 19124
_strings['ignore present recordings'] = 19125
_strings['start time'] = 19126
_strings['end time'] = 19127
_strings['start date'] = 19128
_strings['end date'] = 19129
_strings['minimum duration'] = 19130
_strings['maximum duration'] = 19131
_strings['include unknown genres'] = 19132
_strings['search string'] = 19133
_strings['include description'] = 19134
_strings['case sensitive'] = 19135
_strings['channel unavailable'] = 19136
_strings['name of the new group'] = 19139
_strings['search...'] = 19140
_strings['group'] = 19141
_strings['search guide'] = 19142
_strings['group management'] = 19143
_strings['no groups defined'] = 19144
_strings['grouped'] = 19145
_strings['groups'] = 19146
_strings['channel'] = 19148
_strings['mo'] = 19149
_strings['tu'] = 19150
_strings['we'] = 19151
_strings['th'] = 19152
_strings['fr'] = 19153
_strings['sa'] = 19154
_strings['su'] = 19155
_strings['from'] = 19156
_strings['next recording'] = 19157
_strings['currently recording'] = 19158
_strings['from'] = 19159
_strings['to'] = 19160
_strings['recording active'] = 19162
_strings['recordings'] = 19163
_strings['switch'] = 19165
_strings['pvr information'] = 19166
_strings['scan for missing icons'] = 19167
_strings['hide video information box'] = 19169
_strings['timeout when starting playback'] = 19170
_strings['instant recording duration'] = 19172
_strings['default recording priority'] = 19173
_strings['default recording lifetime'] = 19174
_strings['playback'] = 19177
_strings['show channel information when switching channels'] = 19178
_strings['continue last channel on startup'] = 19189
_strings['background'] = 19190
_strings['pvr service'] = 19191
_strings['none of the connected pvr backends supports scanning for channels.'] = 19192
_strings['continue?'] = 19194
_strings['client actions'] = 19195
_strings['pvr client specific actions'] = 19196
_strings['recording started on: %s'] = 19197
_strings['recording finished on: %s'] = 19198
_strings['channel manager'] = 19199
_strings['channel name:'] = 19201
_strings['channel icon:'] = 19202
_strings['edit channel'] = 19203
_strings['new channel'] = 19204
_strings['group management'] = 19205
_strings['group:'] = 19207
_strings['enter the name of the new channel'] = 19208
_strings['kodi virtual backend'] = 19209
_strings['client'] = 19210
_strings['delete channel'] = 19211
_strings['this list contains changes'] = 19212
_strings['select backend'] = 19213
_strings['enter a valid url for the new channel'] = 19214
_strings['the pvr backend does not support timers.'] = 19215
_strings['all radio channels'] = 19216
_strings['all tv channels'] = 19217
_strings['visible'] = 19218
_strings['ungrouped channels'] = 19219
_strings['channels in'] = 19220
_strings['synchronise channel groups with backend(s)'] = 19221
_strings['recording aborted'] = 19224
_strings['recording scheduled'] = 19225
_strings['recording started'] = 19226
_strings['recording completed'] = 19227
_strings['close channel osd after switching channels'] = 19229
_strings['clear search results'] = 19232
_strings['display a notification on timer updates'] = 19233
_strings['pvr manager is starting up'] = 19235
_strings['loading channels from clients'] = 19236
_strings['loading timers from clients'] = 19237
_strings['loading recordings from clients'] = 19238
_strings['starting background threads'] = 19239
_strings['backend idle time'] = 19244
_strings['wakeup before recording'] = 19246
_strings['daily wakeup'] = 19247
_strings['daily wakeup time (hh:mm:ss)'] = 19248
_strings['filter channels'] = 19249
_strings['lock channel'] = 19257
_strings['unlock channel'] = 19258
_strings['parental control'] = 19259
_strings['unlock duration'] = 19260
_strings['change pin'] = 19261
_strings['parental control. enter pin:'] = 19262
_strings['locked channel. enter pin:'] = 19263
_strings['incorrect pin'] = 19264
_strings['parental locked'] = 19266
_strings['parental locked:'] = 19267
_strings['group items'] = 19270
_strings['conflict warning'] = 19275
_strings['conflict error'] = 19276
_strings['recording conflict'] = 19277
_strings['recording error'] = 19278
_strings['client specific'] = 19279
_strings['client specific settings'] = 19280
_strings['current icon'] = 19282
_strings['no icon'] = 19283
_strings['choose icon'] = 19284
_strings['browse for icon'] = 19285
_strings['searching for channel icons'] = 19286
_strings['all channels'] = 19287
_strings['foreground'] = 19288
_strings['comedy'] = 19504
_strings['romance'] = 19506
_strings['documentary'] = 19519
_strings['sports'] = 19548
_strings['football'] = 19551
_strings['athletics'] = 19554
_strings['equestrian'] = 19558
_strings['ballet'] = 19585
_strings['religion'] = 19599
_strings['literature'] = 19601
_strings['fashion'] = 19607
_strings['languages'] = 19635
_strings['handicraft'] = 19646
_strings['motoring'] = 19647
_strings['cooking'] = 19649
_strings['gardening'] = 19651
_strings['unpublished'] = 19663
_strings['drama'] = 19676
_strings['comedy'] = 19680
_strings['romance'] = 19682
_strings['adult'] = 19684
_strings['saved music folder'] = 20000
_strings['use external dvd player'] = 20001
_strings['external dvd player'] = 20002
_strings['trainers folder'] = 20003
_strings['screenshot folder'] = 20004
_strings['playlists folder'] = 20006
_strings['recordings'] = 20007
_strings['screenshots'] = 20008
_strings['use kodi'] = 20009
_strings['music playlists'] = 20011
_strings['video playlists'] = 20012
_strings['do you wish to launch the game?'] = 20013
_strings['sort by: playlist'] = 20014
_strings['remote thumb'] = 20015
_strings['current thumb'] = 20016
_strings['local thumb'] = 20017
_strings['no thumb'] = 20018
_strings['choose thumbnail'] = 20019
_strings['conflict'] = 20023
_strings['scan new'] = 20024
_strings['scan all'] = 20025
_strings['region'] = 20026
_strings['summary'] = 20037
_strings['lock music window'] = 20038
_strings['lock videos window'] = 20039
_strings['lock pictures window'] = 20040
_strings['lock programs & scripts windows'] = 20041
_strings['lock file manager'] = 20042
_strings['lock settings'] = 20043
_strings['start fresh'] = 20044
_strings['enter master mode'] = 20045
_strings['leave master mode'] = 20046
_strings['create profile "%s"?'] = 20047
_strings['best available'] = 20049
_strings['auto-switch between 16x9 and 4x3'] = 20050
_strings['treat stacked files as single file'] = 20051
_strings['caution'] = 20052
_strings['left master mode'] = 20053
_strings['entered master mode'] = 20054
_strings['allmusic.com thumb'] = 20055
_strings['remove thumbnail'] = 20057
_strings['add profile...'] = 20058
_strings['query info for all albums'] = 20059
_strings['media info'] = 20060
_strings['separate'] = 20061
_strings['shares with default'] = 20062
_strings['shares with default (read only)'] = 20063
_strings['copy default'] = 20064
_strings['profile picture'] = 20065
_strings['lock preferences'] = 20066
_strings['edit profile'] = 20067
_strings['profile lock'] = 20068
_strings['profile directory'] = 20070
_strings['mpaa rating'] = 20074
_strings['enter master lock code'] = 20075
_strings['ask for master lock code on startup'] = 20076
_strings['skin settings'] = 20077
_strings['- no link set -'] = 20078
_strings['enable animations'] = 20079
_strings['disable rss during music'] = 20080
_strings['enable shortcut buttons'] = 20081
_strings['show programs in main menu'] = 20082
_strings['show available disk space c: e: f:'] = 20086
_strings['show available disk space e: f: g:'] = 20087
_strings['drive space free'] = 20089
_strings['enter the name of an existing share'] = 20090
_strings['lock code'] = 20091
_strings['load profile'] = 20092
_strings['profile name'] = 20093
_strings['media sources'] = 20094
_strings['enter profile lock code'] = 20095
_strings['login screen'] = 20096
_strings['master lock code and settings'] = 20100
_strings['entering master lock code always enables master mode'] = 20101
_strings['save changes to profile?'] = 20103
_strings['separate (locked)'] = 20107
_strings['root'] = 20108
_strings['zoom'] = 20109
_strings['upnp settings'] = 20110
_strings['autostart upnp client'] = 20111
_strings['last login: %s'] = 20112
_strings['never logged on'] = 20113
_strings['profile %i / %i'] = 20114
_strings['user login / select a profile'] = 20115
_strings['use lock on login screen'] = 20116
_strings['invalid lock code.'] = 20117
_strings['loading program information'] = 20120
_strings['party on!'] = 20121
_strings['true'] = 20122
_strings['mixing drinks'] = 20123
_strings['filling glasses'] = 20124
_strings['logged on as'] = 20125
_strings['log off'] = 20126
_strings['weave'] = 20129
_strings['blend'] = 20131
_strings['restart video'] = 20132
_strings['edit network location'] = 20133
_strings['remove network location'] = 20134
_strings['do you want to scan the folder?'] = 20135
_strings['memory unit'] = 20136
_strings['memory unit mounted'] = 20137
_strings['unable to mount memory unit'] = 20138
_strings['in port %i, slot %i'] = 20139
_strings['lock screensaver'] = 20140
_strings['set'] = 20141
_strings['username'] = 20142
_strings['enter password for'] = 20143
_strings['shutdown timer'] = 20144
_strings['shutdown interval (in minutes)'] = 20145
_strings['started, shutdown in %im'] = 20146
_strings['shutdown in 30 minutes'] = 20147
_strings['shutdown in 60 minutes'] = 20148
_strings['shutdown in 120 minutes'] = 20149
_strings['custom shutdown timer'] = 20150
_strings['cancel shutdown timer'] = 20151
_strings['lock preferences for %s'] = 20152
_strings['browse...'] = 20153
_strings['summary information'] = 20154
_strings['storage information'] = 20155
_strings['hard disk information'] = 20156
_strings['dvd-rom information'] = 20157
_strings['network information'] = 20158
_strings['video information'] = 20159
_strings['hardware information'] = 20160
_strings['total'] = 20161
_strings['used'] = 20162
_strings['of'] = 20163
_strings['locking not supported'] = 20164
_strings['not locked'] = 20165
_strings['locked'] = 20166
_strings['frozen'] = 20167
_strings['requires reset'] = 20168
_strings['week'] = 20169
_strings['line'] = 20170
_strings['windows network (smb)'] = 20171
_strings['xbmsp server'] = 20172
_strings['ftp server'] = 20173
_strings['upnp server'] = 20175
_strings['done'] = 20177
_strings['shift'] = 20178
_strings['caps lock'] = 20179
_strings['symbols'] = 20180
_strings['backspace'] = 20181
_strings['space'] = 20182
_strings['reload skin'] = 20183
_strings['use poster view styles for tv shows'] = 20185
_strings['please wait'] = 20186
_strings['enable auto scrolling for plot & review'] = 20189
_strings['custom'] = 20190
_strings['enable debug logging'] = 20191
_strings['export music library'] = 20196
_strings['import music library'] = 20197
_strings['no artist found!'] = 20198
_strings['with this enabled, any information that is downloaded for albums and artists will override anything you have set in your song tags, such as genres, year, song artists etc. useful if you have musicbrainz identifiers in your song tags.'] = 20221
_strings['android music'] = 20240
_strings['android videos'] = 20241
_strings['android pictures'] = 20242
_strings['android photos'] = 20243
_strings['party on! (videos)'] = 20250
_strings['mixing drinks (videos)'] = 20251
_strings['filling glasses (videos)'] = 20252
_strings['webdav server (http)'] = 20253
_strings['webdav server (https)'] = 20254
_strings['first logon, edit your profile'] = 20255
_strings['web server directory (http)'] = 20300
_strings['web server directory (https)'] = 20301
_strings['unable to write to folder:'] = 20302
_strings['rss feed'] = 20304
_strings['secondary dns'] = 20307
_strings['dhcp server:'] = 20308
_strings['make new folder'] = 20309
_strings['unknown or onboard (protected)'] = 20311
_strings['videos - library'] = 20314
_strings['sort by: id'] = 20316
_strings['scanning movies using %s'] = 20317
_strings['scanning music videos using %s'] = 20318
_strings['scanning artists using %s'] = 20320
_strings['scanning albums using %s'] = 20321
_strings['movie plot'] = 20323
_strings['play part...'] = 20324
_strings['calibration reset'] = 20325
_strings['this will reset the calibration values for %s'] = 20326
_strings['to its default values.'] = 20327
_strings['browse for destination'] = 20328
_strings['movies are in separate folders that match the movie title'] = 20329
_strings['use folder names for lookups'] = 20330
_strings['file'] = 20331
_strings['use file or folder names in lookups?'] = 20332
_strings['set content'] = 20333
_strings['folder'] = 20334
_strings['look for content recursively?'] = 20335
_strings['unlock sources'] = 20336
_strings['actor'] = 20337
_strings['movie'] = 20338
_strings['director'] = 20339
_strings['movies'] = 20342
_strings['tv shows'] = 20343
_strings['this directory contains'] = 20344
_strings['run automated scan'] = 20345
_strings['scan recursively'] = 20346
_strings['as'] = 20347
_strings['directors'] = 20348
_strings['no video files found in this path!'] = 20349
_strings['tv show information'] = 20351
_strings['episode information'] = 20352
_strings['loading tv show details'] = 20353
_strings['fetching episode guide'] = 20354
_strings['select tv show:'] = 20356
_strings['enter the tv show name'] = 20357
_strings['season %i'] = 20358
_strings['episode'] = 20359
_strings['episodes'] = 20360
_strings['loading episode details'] = 20361
_strings['remove episode from library'] = 20362
_strings['remove tv show from library'] = 20363
_strings['tv show'] = 20364
_strings['episode plot'] = 20365
_strings['* all seasons'] = 20366
_strings['hide watched'] = 20367
_strings['prod code'] = 20368
_strings['show plot for unwatched items'] = 20369
_strings['* hidden to prevent spoilers *'] = 20370
_strings['set season thumb'] = 20371
_strings['season image'] = 20372
_strings['season'] = 20373
_strings['downloading movie information'] = 20374
_strings['unassign content'] = 20375
_strings['original title'] = 20376
_strings['refresh tv show information'] = 20377
_strings['selected folder contains a single tv show'] = 20379
_strings['exclude selected folder from scans'] = 20380
_strings['specials'] = 20381
_strings['selected folder contains a single video'] = 20383
_strings['link to tv show'] = 20384
_strings['remove link to tv show'] = 20385
_strings['recently added movies'] = 20386
_strings['recently added episodes'] = 20387
_strings['studios'] = 20388
_strings['music videos'] = 20389
_strings['recently added music videos'] = 20390
_strings['music video'] = 20391
_strings['remove music video from library'] = 20392
_strings['music video information'] = 20393
_strings['loading music video information'] = 20394
_strings['mixed'] = 20395
_strings['go to albums by artist'] = 20396
_strings['go to album'] = 20397
_strings['play song'] = 20398
_strings['go to music videos from album'] = 20399
_strings['go to music videos by artist'] = 20400
_strings['play music video'] = 20401
_strings['set actor thumb'] = 20403
_strings['remove bookmark'] = 20404
_strings['remove episode bookmark'] = 20405
_strings['set episode bookmark'] = 20406
_strings['downloading music video information'] = 20408
_strings['downloading tv show information'] = 20409
_strings['trailer'] = 20410
_strings['flatten'] = 20411
_strings['flatten tv show seasons'] = 20412
_strings['get fanart'] = 20413
_strings['show fanart in video and music libraries'] = 20414
_strings['scanning for new content'] = 20415
_strings['first aired'] = 20416
_strings['writer'] = 20417
_strings['writers'] = 20418
_strings['replace file names with library titles'] = 20419
_strings['never'] = 20420
_strings['if only one season'] = 20421
_strings['always'] = 20422
_strings['has trailer'] = 20423
_strings['false'] = 20424
_strings['fanart slideshow'] = 20425
_strings['single file'] = 20428
_strings['separate'] = 20429
_strings['export thumbnails and fanart?'] = 20430
_strings['overwrite old files?'] = 20431
_strings['exclude path from library updates'] = 20432
_strings['extract thumbnails and video information'] = 20433
_strings['sets'] = 20434
_strings['combine split video items'] = 20435
_strings['export actor thumbs?'] = 20436
_strings['choose fanart'] = 20437
_strings['local fanart'] = 20438
_strings['no fanart'] = 20439
_strings['current fanart'] = 20440
_strings['remote fanart'] = 20441
_strings['change content'] = 20442
_strings['fanart'] = 20445
_strings['unable to connect to remote server'] = 20449
_strings['countries'] = 20451
_strings['episode'] = 20452
_strings['episodes'] = 20453
_strings['listener'] = 20454
_strings['listeners'] = 20455
_strings['movie set'] = 20457
_strings['tags'] = 20459
_strings['add %s'] = 20460
_strings['remove %s'] = 20461
_strings['new tag...'] = 20462
_strings['a tag with the name "%s" already exists.'] = 20463
_strings['select %s'] = 20464
_strings['manage movie set'] = 20465
_strings['select movie set'] = 20466
_strings['add movie to a new set'] = 20468
_strings['keep current set (%s)'] = 20469
_strings['show hidden files and directories'] = 21330
_strings['connecting to: %s'] = 21336
_strings['add media share...'] = 21359
_strings['look for remote upnp players'] = 21361
_strings['bookmark created'] = 21362
_strings['edit media share'] = 21364
_strings['remove media share'] = 21365
_strings['custom subtitle folder'] = 21366
_strings['movie & alternate subtitle directory'] = 21367
_strings['enable mouse and touch screen support'] = 21369
_strings['thumbnail'] = 21371
_strings['forced dvd player region'] = 21372
_strings['video aspect'] = 21374
_strings['normal'] = 21375
_strings['letterbox'] = 21376
_strings['widescreen'] = 21377
_strings['enable 480p'] = 21378
_strings['enable 720p'] = 21379
_strings['enable 1080i'] = 21380
_strings['enter name of new playlist'] = 21381
_strings['enable scrollbars'] = 21383
_strings['make watched filtering a toggle in video library'] = 21384
_strings['open'] = 21385
_strings['acoustic management level'] = 21386
_strings['fast'] = 21387
_strings['quiet'] = 21388
_strings['enable custom background'] = 21389
_strings['power management level'] = 21390
_strings['high power'] = 21391
_strings['low power'] = 21392
_strings['high standby'] = 21393
_strings['low standby'] = 21394
_strings['unable to cache files bigger than 4gb'] = 21395
_strings['chapter'] = 21396
_strings['high quality pixel shader v2'] = 21397
_strings['use tween animations'] = 21399
_strings['contains'] = 21400
_strings['does not contain'] = 21401
_strings['is'] = 21402
_strings['is not'] = 21403
_strings['starts with'] = 21404
_strings['ends with'] = 21405
_strings['greater than'] = 21406
_strings['less than'] = 21407
_strings['after'] = 21408
_strings['before'] = 21409
_strings['in the last'] = 21410
_strings['not in the last'] = 21411
_strings['settings'] = 21417
_strings['multilingual'] = 21418
_strings['value to match'] = 21420
_strings['smart playlist rule'] = 21421
_strings['match items where'] = 21422
_strings['new rule...'] = 21423
_strings['items must match'] = 21424
_strings['all of the rules'] = 21425
_strings['one or more of the rules'] = 21426
_strings['limit to'] = 21427
_strings['no limit'] = 21428
_strings['order by'] = 21429
_strings['ascending'] = 21430
_strings['descending'] = 21431
_strings['edit smart playlist'] = 21432
_strings['find items where'] = 21434
_strings['edit'] = 21435
_strings['%i items'] = 21436
_strings['new smart playlist...'] = 21437
_strings['%c drive'] = 21438
_strings['edit party mode rules'] = 21439
_strings['home folder'] = 21440
_strings['watched count'] = 21441
_strings['episode title'] = 21442
_strings['video resolution'] = 21443
_strings['audio channels'] = 21444
_strings['video codec'] = 21445
_strings['audio codec'] = 21446
_strings['audio language'] = 21447
_strings['subtitle language'] = 21448
_strings['remote control sends keyboard presses'] = 21449
_strings['edit'] = 21450
_strings['internet connection required.'] = 21451
_strings['root filesystem'] = 21453
_strings['external storage'] = 21456
_strings['watched episode count'] = 21457
_strings['group by'] = 21458
_strings['mixed'] = 21459
_strings['subtitle position on screen'] = 21460
_strings['fixed'] = 21461
_strings['bottom of video'] = 21462
_strings['below video'] = 21463
_strings['top of video'] = 21464
_strings['above video'] = 21465
_strings['%.1f to %.1f'] = 21467
_strings['%d to %d'] = 21468
_strings['%s to %s'] = 21469
_strings['%s [%d]'] = 21470
_strings['(external)'] = 21602
_strings['file name'] = 21800
_strings['file path'] = 21801
_strings['file size'] = 21802
_strings['slide index'] = 21804
_strings['resolution'] = 21805
_strings['comment'] = 21806
_strings['jpeg process'] = 21808
_strings['description'] = 21821
_strings['camera make'] = 21822
_strings['camera model'] = 21823
_strings['exif comment'] = 21824
_strings['firmware'] = 21825
_strings['aperture'] = 21826
_strings['focal length'] = 21827
_strings['focus distance'] = 21828
_strings['exposure'] = 21829
_strings['exposure time'] = 21830
_strings['exposure bias'] = 21831
_strings['exposure mode'] = 21832
_strings['flash used'] = 21833
_strings['white-balance'] = 21834
_strings['light source'] = 21835
_strings['metering mode'] = 21836
_strings['iso'] = 21837
_strings['digital zoom'] = 21838
_strings['ccd width'] = 21839
_strings['gps latitude'] = 21840
_strings['gps longitude'] = 21841
_strings['gps altitude'] = 21842
_strings['orientation'] = 21843
_strings['sub-location'] = 21857
_strings['image type'] = 21858
_strings['time created'] = 21859
_strings['supplemental categories'] = 21860
_strings['keywords'] = 21861
_strings['caption'] = 21862
_strings['author'] = 21863
_strings['headline'] = 21864
_strings['special instructions'] = 21865
_strings['category'] = 21866
_strings['byline'] = 21867
_strings['byline title'] = 21868
_strings['credit'] = 21869
_strings['source'] = 21870
_strings['copyright notice'] = 21871
_strings['object name'] = 21872
_strings['city'] = 21873
_strings['state'] = 21874
_strings['country'] = 21875
_strings['date created'] = 21877
_strings['urgency'] = 21878
_strings['country code'] = 21879
_strings['reference service'] = 21880
_strings['attempt to skip introduction before dvd menu'] = 21882
_strings['saved music'] = 21883
_strings['query info for all artists'] = 21884
_strings['downloading album information'] = 21885
_strings['downloading artist information'] = 21886
_strings['biography'] = 21887
_strings['discography'] = 21888
_strings['searching artist'] = 21889
_strings['select artist'] = 21890
_strings['artist information'] = 21891
_strings['instruments'] = 21892
_strings['born'] = 21893
_strings['formed'] = 21894
_strings['themes'] = 21895
_strings['disbanded'] = 21896
_strings['died'] = 21897
_strings['years active'] = 21898
_strings['label'] = 21899
_strings['update library on startup'] = 22000
_strings['hide progress of library updates'] = 22001
_strings['dns suffix'] = 22002
_strings['%2.3fs'] = 22003
_strings['delayed by: %2.3fs'] = 22004
_strings['ahead by: %2.3fs'] = 22005
_strings['subtitle offset'] = 22006
_strings['opengl vendor:'] = 22007
_strings['opengl renderer:'] = 22008
_strings['opengl version:'] = 22009
_strings['gpu temperature:'] = 22010
_strings['cpu temperature:'] = 22011
_strings['total memory'] = 22012
_strings['profile data'] = 22013
_strings['use dim if paused during video playback'] = 22014
_strings['all recordings'] = 22015
_strings['by title'] = 22016
_strings['by group'] = 22017
_strings['recordings by title'] = 22019
_strings['guide'] = 22020
_strings['show video files in listings'] = 22022
_strings['direct3d version:'] = 22024
_strings['font'] = 22030
_strings['size'] = 22031
_strings['colours'] = 22032
_strings['charset'] = 22033
_strings['default select action'] = 22079
_strings['choose'] = 22080
_strings['more...'] = 22082
_strings['play all'] = 22083
_strings['teletext not available'] = 23049
_strings['part %i'] = 23051
_strings['buffering %i bytes'] = 23052
_strings['stopping'] = 23053
_strings['running'] = 23054
_strings['add-on'] = 24000
_strings['add-ons'] = 24001
_strings['add-on options'] = 24002
_strings['media sources'] = 24005
_strings['movie information'] = 24007
_strings['screensaver'] = 24008
_strings['script'] = 24009
_strings['visualisation'] = 24010
_strings['add-on repository'] = 24011
_strings['subtitles'] = 24012
_strings['lyrics'] = 24013
_strings['tv information'] = 24014
_strings['music video information'] = 24015
_strings['album information'] = 24016
_strings['artist information'] = 24017
_strings['services'] = 24018
_strings['pvr clients'] = 24019
_strings['configure'] = 24020
_strings['disable'] = 24021
_strings['enable'] = 24022
_strings['disabled'] = 24023
_strings['add-on disabled'] = 24024
_strings['weather'] = 24027
_strings['weather.com (standard)'] = 24028
_strings['service for weather information'] = 24029
_strings['error loading settings'] = 24031
_strings['check for updates'] = 24034
_strings['uninstall'] = 24037
_strings['install'] = 24038
_strings['(clear the current setting)'] = 24040
_strings['install from zip file'] = 24041
_strings['downloading %i%%'] = 24042
_strings['version:'] = 24051
_strings['disclaimer'] = 24052
_strings['license:'] = 24053
_strings['check for updates'] = 24055
_strings['last updated %s'] = 24056
_strings['auto update'] = 24063
_strings['add-on enabled'] = 24064
_strings['add-on updated'] = 24065
_strings['update available'] = 24068
_strings['update'] = 24069
_strings['an unknown error has occurred.'] = 24071
_strings['settings required'] = 24072
_strings['needs to restart'] = 24074
_strings['disable'] = 24075
_strings['try to reconnect?'] = 24080
_strings['add-on libraries'] = 24082
_strings['information libraries'] = 24083
_strings['add-on restarts'] = 24089
_strings['add-on is incompatible or has been marked broken in repository.'] = 24096
_strings['would you like to disable it on your system?'] = 24097
_strings['broken'] = 24098
_strings['would you like to switch to this skin?'] = 24099
_strings['unable to load skin'] = 24102
_strings['skin is missing some files'] = 24103
_strings['add-on is incompatible due to unmet dependencies.'] = 24104
_strings['pause when searching for subtitles'] = 24105
_strings['specify where downloaded subtitles should be saved, the same location as the video or a custom location.'] = 24106
_strings['searching for subtitles ...'] = 24107
_strings['%d subtitles found'] = 24108
_strings['no subtitles found'] = 24109
_strings['downloading subtitles ...'] = 24110
_strings['languages to download subtitles for'] = 24111
_strings['failed to download subtitle'] = 24113
_strings['no subtitle services installed'] = 24114
_strings['subtitle storage location'] = 24115
_strings['manual search string'] = 24120
_strings['enter search string'] = 24121
_strings['update all'] = 24122
_strings['pause the current video while searching for subtitles and resume once the subtitle is available.'] = 24123
_strings['next to the video'] = 24124
_strings['custom location'] = 24125
_strings['auto download first subtitle'] = 24126
_strings['automatically download first subtitle from the search result list'] = 24127
_strings['configuration has been moved'] = 24128
_strings['the configuration of xbmc has been moved to the new location for kodi. please refer to http://kodi.wiki/view/migration - this message will not be shown again!'] = 24129
_strings['hide incompatible'] = 24999
_strings['notifications'] = 25000
_strings['hide foreign'] = 25001
_strings['select from all titles ...'] = 25002
_strings['show blu-ray menu'] = 25003
_strings['play main title: %d'] = 25004
_strings['title: %d'] = 25005
_strings['select playback item'] = 25006
_strings['chapters: %u - duration: %s'] = 25007
_strings['playback of blu-ray failed'] = 25008
_strings['the menu of this blu-ray is not supported'] = 25009
_strings['qwerty keyboard'] = 29801
#############################################
# 30000-30999: Addon-specific string-range  #
# See bottom of file for those strings      #
#############################################
# 31000-31999: Skin-specific string-range   #
#############################################
# 32000-32999: Script-specific string-range #
#############################################
# 33000-33999: Common Addon string-range    #
#############################################
_strings['trailer quality'] = 33001
_strings['stream'] = 33002
_strings['download'] = 33003
_strings['download & play'] = 33004
_strings['download & save'] = 33005
_strings['today'] = 33006
_strings['tomorrow'] = 33007
_strings['saving'] = 33008
_strings['copying'] = 33009
_strings['set download directory'] = 33010
_strings['search duration'] = 33011
_strings['short'] = 33012
_strings['long'] = 33013
_strings['use dvd player instead of regular player'] = 33014
_strings['ask for download before playing video'] = 33015
_strings['clips'] = 33016
_strings['restart plug-in to enable'] = 33017
_strings['tonight'] = 33018
_strings['condition'] = 33020
_strings['precipitation'] = 33021
_strings['precip'] = 33022
_strings['humid'] = 33023
_strings['feels'] = 33024
_strings['observed'] = 33025
_strings['departure from normal'] = 33026
_strings['sunrise'] = 33027
_strings['sunset'] = 33028
_strings['details'] = 33029
_strings['outlook'] = 33030
_strings['coverflow'] = 33031
_strings['translate text'] = 33032
_strings['map list %s category'] = 33033
_strings['maps'] = 33035
_strings['hourly'] = 33036
_strings['weekend'] = 33037
_strings['%s day'] = 33038
_strings['alert'] = 33049
_strings['alerts'] = 33050
_strings['check'] = 33052
_strings['configure the'] = 33053
_strings['seasons'] = 33054
_strings['use your'] = 33055
_strings['watch your'] = 33056
_strings['listen to'] = 33057
_strings['view your'] = 33058
_strings['configure the'] = 33059
_strings['power'] = 33060
_strings['menu'] = 33061
_strings['play the'] = 33062
_strings['options'] = 33063
_strings['editor'] = 33065
_strings['about your'] = 33066
_strings['star rating'] = 33067
_strings['background'] = 33068
_strings['backgrounds'] = 33069
_strings['custom background'] = 33070
_strings['custom backgrounds'] = 33071
_strings['no data found!'] = 33077
_strings['next page'] = 33078
_strings['love'] = 33079
_strings['hate'] = 33080
_strings['path to script'] = 33082
_strings['enable custom script button'] = 33083
_strings['auto login'] = 33084
_strings['failed to start'] = 33100
_strings['remote communication server'] = 33103
_strings['lame'] = 34000
_strings['vorbis'] = 34001
_strings['wav'] = 34002
_strings['dxva2'] = 34003
_strings['vaapi'] = 34004
_strings['number of channels'] = 34100
_strings['2.0'] = 34101
_strings['2.1'] = 34102
_strings['3.0'] = 34103
_strings['3.1'] = 34104
_strings['4.0'] = 34105
_strings['4.1'] = 34106
_strings['5.0'] = 34107
_strings['5.1'] = 34108
_strings['7.0'] = 34109
_strings['7.1'] = 34110
_strings['play gui sounds'] = 34120
_strings['only when playback stopped'] = 34121
_strings['always'] = 34122
_strings['never'] = 34123
_strings['44.1'] = 34124
_strings['48.0'] = 34125
_strings['88.2'] = 34126
_strings['96.0'] = 34127
_strings['192.0'] = 34128
_strings['can\'t find a next item to play'] = 34201
_strings['can\'t find a previous item to play'] = 34202
_strings['failed to start zeroconf'] = 34300
_strings['failed to initialise audio device'] = 34402
_strings['use gestures for navigation:'] = 34404
_strings['peripherals'] = 35000
_strings['generic hid device'] = 35001
_strings['generic disk'] = 35003
_strings['new device configured'] = 35005
_strings['device removed'] = 35006
_strings['keymap to use for this device'] = 35007
_strings['keymap enabled'] = 35008
_strings['enable joystick and gamepad support'] = 35100
_strings['disable joystick when this device is present'] = 35102
_strings['pulse-eight nyxboard'] = 36001
_strings['switch to keyboard side command'] = 36002
_strings['switch to remote side command'] = 36003
_strings['press \"user\" button command'] = 36004
_strings['enable switch side commands'] = 36005
_strings['hdmi port number'] = 36015
_strings['connected'] = 36016
_strings['use the tv\'s language setting'] = 36018
_strings['connected to hdmi device'] = 36019
_strings['physical address (overrules hdmi port)'] = 36021
_strings['configuration updated'] = 36023
_strings['failed to set the new configuration. please check your settings.'] = 36024
_strings['this device needs servicing'] = 36027
_strings['ignore'] = 36028
_strings['when the tv is switched off'] = 36029
_strings['connection lost'] = 36030
_strings['always'] = 36035
_strings['tv'] = 36037
_strings['amplifier / avr device'] = 36038
_strings['tv and avr device (explicit)'] = 36039
_strings['* item folder'] = 36041
_strings['use limited colour range (16-235)'] = 36042
_strings['change the look and feel of the user interface.'] = 36101
_strings['change the theme associated with your selected skin.'] = 36105
_strings['change the colours of your selected skin.'] = 36106
_strings['choose the fonts displayed in the user interface. the font sets are configured by your skin.'] = 36107
_strings['resize the view of the user interface.'] = 36108
_strings['turn this off to remove the scrolling rss news ticker.'] = 36111
_strings['edit the rss feeds.'] = 36112
_strings['chooses the language of the user interface.'] = 36114
_strings['select the formats for temperature, time and date. the available options depend on the selected language.'] = 36115
_strings['select country location.'] = 36117
_strings['select your current timezone.'] = 36118
_strings['display the (..) item in lists for visiting the parent folder.'] = 36122
_strings['show the add source button in root sections of the user interface.'] = 36126
_strings['show hidden files and directories when listing files.'] = 36127
_strings['preview the selected screensaver.'] = 36132
_strings['no info available yet.'] = 36135
_strings['no info available yet.'] = 36136
_strings['no info available yet.'] = 36137
_strings['section that contains settings related to videos and how they are handled.'] = 36138
_strings['hide the library scanning progress bar during scans.'] = 36147
_strings['remove items from your library that can\'t be found (either renamed, deleted, or on removable storage that is currently unplugged).'] = 36148
_strings['enable automatic playback of the next file in the list.'] = 36152
_strings['adjust the method used to process and display video.'] = 36153
_strings['enable vdpau hardware decoding of video files, mainly used for nvidia graphics and in some circumstances amd graphics.'] = 36155
_strings['enable vaapi hardware decoding of video files, mainly used for intel graphics and in some circumstances amd graphics.'] = 36156
_strings['enable dxva2 hardware decoding of video files.'] = 36158
_strings['enable crystalhd decoding of video files.'] = 36159
_strings['enable openmax hardware decoding of video files.'] = 36161
_strings['enable videotoolbox hardware decoding of video files.'] = 36162
_strings['allow the refresh rate of the display to be changed so that it best matches the video frame rate. this may yield smoother video playback.'] = 36164
_strings['select the zoom level that 4:3 videos are shown on widescreen displays.'] = 36171
_strings['extract thumbnails and metadata information such as codec and aspect ratio from videos.'] = 36178
_strings['when a file is scanned into the library it will display the metadata title instead of the file name.'] = 36179
_strings['no info available yet.'] = 36181
_strings['set the font size to be used for subtitles.'] = 36186
_strings['set the font style to be used for subtitles.'] = 36187
_strings['set the font colour to be used for subtitles.'] = 36188
_strings['set the font character set to be used for subtitles.'] = 36189
_strings['set a custom directory for your subtitles. this can be a file share.'] = 36191
_strings['location of subtitles on the screen.'] = 36192
_strings['autorun dvd video when inserted in drive.'] = 36194
_strings['force a region for dvd playback.'] = 36195
_strings['no info available yet.'] = 36197
_strings['import channel groups from the pvr backend (if supported). will delete user created groups if they\'re not found on the backend.'] = 36204
_strings['open the channel manager, which allows modifying the channel order, channel name, icon, etc.'] = 36207
_strings['instruct the backend to search for channels (if supported).'] = 36208
_strings['display programming information when changing channels, such as the current tv show.'] = 36212
_strings['close the on screen display controls after switching channels.'] = 36214
_strings['folder where channel icons are stored.'] = 36216
_strings['scan for missing channel icons.'] = 36217
_strings['continue with the last viewed channel on startup.'] = 36228
_strings['when pressing channel up or down, the actual channel switch is delayed, allowing the user to flip to a channel number without waiting for each channel switch.'] = 36232
_strings['display a notification when timers are added, finished or removed by the backend.'] = 36239
_strings['the command will not be executed when a recording will be started within this timeout.'] = 36242
_strings['time to subtract from the start time of the next scheduled recording.'] = 36244
_strings['execute the wakeup command every day at the given time.'] = 36245
_strings['when to execute the daily wakeup command.'] = 36246
_strings['enter a new pin code to unlock parental locked channels.'] = 36249
_strings['ask for the pin code again when trying to access a parental locked channel and the code hasn\'t been asked for this duration.'] = 36250
_strings['section that contains settings related to music files and how they are handled.'] = 36253
_strings['no info available yet.'] = 36260
_strings['when songs are selected they are queued instead of playback starting immediately.'] = 36266
_strings['smoothly fade from one audio track to the next. you can set the amount of overlap from 1-15 seconds.'] = 36271
_strings['allow crossfading to occur when both tracks are from the same album.'] = 36272
_strings['select the visualisation that will be displayed while listening to music.'] = 36273
_strings['control the way that the names of songs are displayed in the user interface. in order to function properly, tag reading needs to be enabled.'] = 36275
_strings['used for formatting the second column in file lists.'] = 36276
_strings['control the way that the names of songs are displayed in the now playing list.'] = 36277
_strings['used for formatting the second column in the now playing list.'] = 36278
_strings['control the way that the names of songs are displayed in library lists.'] = 36279
_strings['used for formatting the second column in library lists.'] = 36280
_strings['autorun cds when inserted in drive.'] = 36283
_strings['select the location on your hard drive where ripped tracks will be saved to.'] = 36285
_strings['control how saved music is named from the tags. tags: [b]%n[/b]: tracknumber, [b]%s[/b]: discnumber, [b]%a[/b]: artist, [b]%t[/b]: title, [b]%b[/b]: album, [b]%g[/b]: genre, [b]%y[/b]: year, [b]%f[/b]: filename, [b]%d[/b]: duration, [b]%j[/b]: date, [b]%r[/b]: rating, [b]%i[/b]: filesize.'] = 36286
_strings['select which audio encoder to use when ripping.'] = 36287
_strings['select which quality you want to rip your files.'] = 36288
_strings['select which bitrate to use for the specified audio encoder for audio compression.'] = 36289
_strings['for flac define compression level, default 5.'] = 36290
_strings['auto eject disc after rip is complete.'] = 36291
_strings['no info available yet.'] = 36302
_strings['no info available yet.'] = 36303
_strings['section that contains settings related to pictures and how they are handled.'] = 36304
_strings['automatically generate picture thumbnails when entering picture folder.'] = 36307
_strings['show videos in picture file lists.'] = 36309
_strings['no info available yet.'] = 36310
_strings['select the amount of time that each image is displayed in a slideshow.'] = 36312
_strings['images in a slideshow will pan and zoom while displayed.'] = 36313
_strings['view slideshow images in a random order.'] = 36314
_strings['section that contains weather related settings.'] = 36315
_strings['select up to three locations for which the weather can be displayed.'] = 36317
_strings['enable the upnp client. this allows you to stream media from any upnp server with a control point and control playback from that server.'] = 36325
_strings['define the remote control port.'] = 36335
_strings['define the remote control port range.'] = 36336
_strings['define the maximum number of clients that can connect.'] = 36337
_strings['initial repeat delay (ms).'] = 36339
_strings['continuous repeat delay (ms).'] = 36340
_strings['enable airplay password protection.'] = 36344
_strings['sets the airplay password.'] = 36345
_strings['if a wins server is running on the network, enter its ip address here. otherwise, leave blank.'] = 36347
_strings['if a wins server is running on the network, enter its workgroup name here. otherwise, leave blank.'] = 36348
_strings['changes the resolution that the user interface is displayed in.'] = 36352
_strings['changes the refresh rate that the user interface is displayed in.'] = 36353
_strings['calibrate the user interface by adjusting the overscan. use this tool if the image being displayed is too large or small for your display.'] = 36357
_strings['test patterns for display hardware calibration.'] = 36358
_strings['use limited colour range (16-235) instead of full colour range (0-255). limited range should be used if your display is a regular hdmi tv and doesn\'t have a pc or other mode to display full range colour, however if your display is a pc monitor then leave this disabled to get proper blacks.'] = 36359
_strings['boost ac3 streams that have been downmixed to 2 channels.'] = 36363
_strings['select to enable upmixing of 2 channel audio to the number of audio channels specified by the channel configuration.'] = 36364
_strings['select this option if your receiver is capable of decoding truehd streams.'] = 36369
_strings['select the device to be used for playback of audio that has been decoded such as mp3.'] = 36371
_strings['configure how interface sounds are handled, such as menu navigation and important notifications.'] = 36373
_strings['configure any attached peripheral devices.'] = 36375
_strings['when activated, your keyboard arrows will move the selection on the virtual keyboard. when deactivated, they will move the cursor from your text.'] = 36376
_strings['configure which proxy type is used.'] = 36381
_strings['configure the proxy server address.'] = 36382
_strings['configure the proxy server port.'] = 36383
_strings['configure the proxy server username.'] = 36384
_strings['configure the proxy server password.'] = 36385
_strings['turn off display when idle. useful for tvs that turn off when there is no display signal detected.'] = 36388
_strings['turn debug logging on or off. useful for troubleshooting.'] = 36392
_strings['enable cache for playback of dvd from dvd-rom.'] = 36407
_strings['enable cache of unknown types from internet.'] = 36409
_strings['no info available yet.'] = 36410
_strings['no info available yet.'] = 36411
_strings['no info available yet.'] = 36412
_strings['no info available yet.'] = 36413
_strings['no info available yet.'] = 36414
_strings['no info available yet.'] = 36415
_strings['specify the type of remote used.'] = 36416
_strings['specify the delay between button sequences on a universal remote.'] = 36418
_strings['define locations used for retrieving weather information.'] = 36419
_strings['bypassing vdpau mixer saves resources on low power systems but slightly reduces picture quality.'] = 36421
_strings['show context menu'] = 36425
_strings['switch to channel'] = 36426
_strings['show information'] = 36427
_strings['record'] = 36428
_strings['configure how video processing will be accelerated. this includes things like decoding and scaling.'] = 36430
_strings['select virtual keyboard layouts.'] = 36432
_strings['stereoscopic 3d mode'] = 36501
_strings['disabled'] = 36502
_strings['side by side'] = 36504
_strings['interlaced'] = 36507
_strings['playback mode of stereoscopic 3d videos'] = 36520
_strings['ask me'] = 36521
_strings['preferred mode'] = 36524
_strings['same as movie (autodetect)'] = 36525
_strings['disable stereoscopic 3d mode when playback ended'] = 36526
_strings['select playback mode'] = 36527
_strings['select stereoscopic 3d mode'] = 36528
_strings['select alternate mode...'] = 36531
_strings['same as movie'] = 36532
_strings['stereoscopic 3d mode of video'] = 36535
_strings['changes the stereoscopic 3d mode of the user interface.'] = 36539
_strings['the preferred mode in which stereoscopic 3d media such as videos should be played.'] = 36540
_strings['allows volume control from airplay clients.'] = 36541
_strings['output to both analogue (headphones) and hdmi'] = 36542
_strings['enable this to make dialogue louder compared to background sounds when downmixing multichannel audio'] = 36543
_strings['enable hardware decoding of video files.'] = 36544
_strings['stereoscopic 3d depth of subtitles'] = 36545
_strings['sets the visual depth of subtitles for stereoscopic 3d videos. the higher the value, the closer the subtitles will appear to the viewer.'] = 36546
_strings['use higher quality textures for covers and fanart (uses more memory)'] = 36547
_strings['limits resolution of gui to save memory. does not affect video playback. requires restart.'] = 36548
_strings['movie'] = 36900
_strings['movies'] = 36901
_strings['tv show'] = 36902
_strings['tv shows'] = 36903
_strings['season'] = 36904
_strings['seasons'] = 36905
_strings['episode'] = 36906
_strings['episodes'] = 36907
_strings['set'] = 36910
_strings['sets'] = 36911
_strings['video'] = 36912
_strings['videos'] = 36913
_strings['music'] = 36914
_strings['music'] = 36915
_strings['artist'] = 36916
_strings['artists'] = 36917
_strings['album'] = 36918
_strings['albums'] = 36919
_strings['song'] = 36920
_strings['songs'] = 36921
_strings['(cc)'] = 37011
_strings['(forced)'] = 37012
_strings['last used profile'] = 37014
_strings['dual audio output'] = 37017
_strings['boost centre channel when downmixing'] = 37018
_strings['enable higher colour depth artwork'] = 37020
_strings['set gui resolution limit'] = 37021
_strings['do you wish to stop playback on the remote device?'] = 37023
_strings['configure audio encoder settings such as quality and compression level'] = 37025
_strings['auto'] = 37026
_strings['540'] = 37027
_strings['720'] = 37028
_strings['900'] = 37029
_strings['unlimited'] = 37030
_strings['gpu accelerated'] = 38010

#GENERATED
_strings['[color teal]are you sure?[/color]'] = 30401
_strings['[color teal]process complete[/color]'] = 30402
_strings['this view is now default'] = 30491
_strings['[i]next page[/i]'] = 30500
_strings['[color blue]settings[/color]'] = 30701
_strings['[color orange]search[/color]'] = 30702
_strings['[color purple]clear history[/color]'] = 30703
_strings['link'] = 30704
_strings['[color red]unplayable stream[/color]'] = 30705
_strings['discover great streaming playlists!'] = 30706
_strings['[color orange]trailer[/color]'] = 30707
_strings['information'] = 30708
_strings['set movies view'] = 30711
_strings['set tv shows view'] = 30712
_strings['set seasons view'] = 30713
_strings['set episodes view'] = 30714
_strings['general'] = 30715
_strings['metadata'] = 30716
_strings['enable metadata'] = 30717
_strings['cache'] = 30718
_strings['clear cache'] = 30719
_strings['path'] = 30720
_strings['downloads'] = 30721
_strings['download item'] = 30722
_strings['credits'] = 30723
_strings['show credits'] = 30724
_strings['add-on settings'] = 30725
_strings['[color teal]opening stream[/color]'] = 30726
_strings['accounts'] = 30727
_strings['user'] = 30728
_strings['email'] = 30729
_strings['password'] = 30730
_strings['[color orange]please wait...[/color]'] = 30731
_strings['opening image'] = 30732
_strings['scraper settings'] = 30733
_strings['open scraper settings'] = 30734
_strings['filtering options'] = 30735
_strings['allow openload links'] = 30736
_strings['allow thevideo.me links'] = 30737
_strings['allow vidup.me links'] = 30738
_strings['try searching for alternate spelling if present (slower)'] = 30739
_strings['third party'] = 30740
_strings['resolver settings'] = 30741
_strings['open resolver settings'] = 30742
_strings['enable debrid'] = 30743
_strings['enable link selection dialog'] = 30744
_strings['enable link selection fallthrough'] = 30745
_strings['scoreboard'] = 30751
_strings['archived games'] = 30752
_strings['live games , requires some modifications to get working visit forum.'] = 30753
_strings['if list returns blank, feed is not up yet.'] = 30754
_strings['feed not available yet'] = 30755
_strings['pick a bandwidth'] = 30756
_strings['offer to install required 3rd party repositories'] = 30757
_strings['enable debugging mode'] = 30758
_strings['message options'] = 30760
_strings['enable possibly offensive messages'] = 30761
_strings['parts of this addon may rely on certain[cr]third party addons.'] = 30762
_strings['[cr]'] = 30763
_strings['you can choose whether or not to install[cr]the relevant repos.'] = 30764
_strings['we recommend installing the relevant repos[cr]to ensure your addons auto-update.'] = 30765
_strings['offer to install required 3rd party addons'] = 30766
_strings['disable all loading messages'] = 30767
_strings['dev mode'] = 30770
_strings['please wait...'] = 30807
_strings['checking login details and update files'] = 30808
_strings['wrong password'] = 30825
_strings['you have entered an incorrect password for this account, please check settings and try again.'] = 30826
_strings['wrong username'] = 30827
_strings['you have not entered a valid username, please either correct your login details or register for free at www.noobsandnerds.com.'] = 30828
_strings['account restricted'] = 30829
_strings['there is a ban on your account, the most likely cause for this is account sharing. please make sure you haven\'t accidentally left your login details on a shared computer.'] = 30830
_strings['re-activate account'] = 30831
_strings['you need to re-activate your account on the new forum. simply visit the forum at www.noobsandnerds.com and login with your existing credentials.'] = 30832
_strings['servers busy'] = 30833
_strings['sorry the servers appear to be struggling with demand, please try again. sorry for any inconvenience, we are currently working on improving the speeds.'] = 30834
_strings['no login details'] = 30835
_strings['you have enabled the login feature but not entered any details. please add your login details or disable the option.'] = 30836
_strings['login (for playlisters only)'] = 30843
_strings['forum to use for login'] = 30844
_strings['username'] = 30845
_strings['password'] = 30846
_strings['[color=gold]----------------------------------------------------[/color]'] = 30897
_strings['[color=gold]use latest test version (donators only)[/color]'] = 30900
_strings['check login details'] = 30901
_strings['please double check your login credentials, once entered correctly try running the add-on to activate the test version then come back and try again.'] = 30902
_strings['log options - add an email to receive a link to your log'] = 30903
_strings['enable debug mode (enable if asking for help on forum)'] = 30904
_strings['always skip kodi.old.log (log from previous run)'] = 30905
_strings['email address'] = 30906
_strings['[color=gold]click to upload log[/color]'] = 30907
_strings['-- open test settings'] = 30933
_strings['you need to enable the login option to use the test version. this feature is only available to members who have donated towards the noobsandnerds development fund. you can disable this option to continue using the standard version.'] = 30962
_strings['no test version available'] = 30963
_strings['there is no test version available for this add-on at this time.'] = 30964
_strings['error'] = 30965
_strings['sorry there was an error trying to retrieve the latest test version, the developer may be working on pushing a new update.'] = 30966
_strings['repository required'] = 30967
_strings['one of the addons required are hosted on a third party repository. if you don\'t have this installed you may miss out on important updates from the developer. do you want to install:'] = 30968
_strings['installing repository'] = 30969
_strings['please wait...'] = 30970
_strings['checking updates'] = 30971
_strings['just checking for any updates on the repo.'] = 30972
_strings['unable to install repo'] = 30973
_strings['sorry there was an error trying to install this repository, please let the team at noobsandnerds.com know so they can update the add-on portal. thank you.'] = 30974
_strings['update available'] = 30975
_strings['the noobsandnerds add-on portal is showing a newer version of [color=gold]%s[/color] is available. would you like to update to version: [color=dodgerblue]%s[/color]'] = 30976
_strings['addon required'] = 30977
_strings['the following third party add-on is required, if you don\'t have this installed you may find certain features fail to work. do you want to install?'] = 30978
_strings['installing updates'] = 30979
_strings['start from beginning'] = 32501
_strings['resume from %s'] = 32502
_strings['resume'] = 32503
_strings['eimify your jen'] = 32504
_strings['meta info language'] = 32505
_strings['select language'] = 32506
_strings['metadata provider'] = 32507
_strings['movie metadata provider'] = 32508
_strings['tv metadata provider'] = 32509
_strings['choose default link'] = 32510
_strings['NuMb3r5 Will Find Your Links'] = 32511
_strings['choose jen theme'] = 32512
_strings['select theme'] = 32513
_strings['gifs'] = 32514
_strings['enable gifs'] = 32515
_strings['choose tv metadata provider'] = 30000
_strings['run setup wizard?'] = 30001
_strings['enable gif support?\n'] = 30002
_strings['clear scraper cache?'] = 30003
_strings['hd'] = 30004
_strings['both'] = 30005
_strings['returned empty for '] = 30006
_strings['choose selector type'] = 30007
_strings['sorry, server is down'] = 30008
_strings['may cause issues on lower end devices'] = 30009
_strings['testings'] = 30010
_strings['search'] = 30011
_strings['tmdb'] = 30012
_strings['processing lists'] = 30013
_strings['clear gif cache?'] = 30014
_strings['message'] = 30015
_strings['choose theme'] = 30016
_strings['hd/sd'] = 30017
_strings['tvdb'] = 30018
_strings['clear xml cache?'] = 30019
_strings['clear metadata?'] = 30020
_strings['%s of %s'] = 30021
_strings['trakt'] = 30022
_strings['loading items'] = 30023
_strings['link selector'] = 30024
_strings['sd'] = 30025
_strings['remove search'] = 30026
_strings['no local file found, and server seems down'] = 30027
_strings['clear queue'] = 30028
_strings['queue season'] = 30029
_strings['queue episode'] = 30030
_strings['set episode view'] = 30031
_strings['please wait'] = 30032
_strings['processing link'] = 30033
_strings['set movie view'] = 30034
_strings['gif not found: '] = 30035
_strings['queue tv show'] = 30036
_strings['previous playback detected'] = 30037
_strings['restart'] = 30038
_strings['extended info'] = 30039
_strings['queue cleared'] = 30040
_strings['settings'] = 30041
_strings['finished queueing'] = 30042
_strings['processing item'] = 30043
_strings['queue is empty'] = 30044
_strings['set tv show view'] = 30045
_strings['set view'] = 30046
_strings['queue movie'] = 30047
_strings['view set for %s'] = 30048
_strings['trailer'] = 30049
_strings['play queue'] = 30050
_strings['loading database file'] = 30051
_strings['show queue'] = 30052
_strings['enter search term'] = 30053
_strings['add search'] = 30054
_strings['try uncached'] = 30055
_strings['queue item'] = 30056
_strings['processing metadata'] = 30057
_strings['set season view'] = 30058
_strings['all episodes'] = 30059
